// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Request to add a method to an existing Resource resource.
 */
class PutMethodRequest private constructor(builder: Builder) {
    /**
     * Specifies whether the method required a valid ApiKey.
     */
    val apiKeyRequired: kotlin.Boolean = builder.apiKeyRequired
    /**
     * A list of authorization scopes configured on the method. The scopes are used with a `COGNITO_USER_POOLS` authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.
     */
    val authorizationScopes: List<String>? = builder.authorizationScopes
    /**
     * &#91;Required&#93; The method's authorization type. Valid values are `NONE` for open access, `AWS_IAM` for using AWS IAM permissions, `CUSTOM` for using a custom authorizer, or `COGNITO_USER_POOLS` for using a Cognito user pool.
     */
    val authorizationType: kotlin.String? = builder.authorizationType
    /**
     * Specifies the identifier of an Authorizer to use on this Method, if the type is CUSTOM or COGNITO_USER_POOLS. The authorizer identifier is generated by API Gateway when you created the authorizer.
     */
    val authorizerId: kotlin.String? = builder.authorizerId
    /**
     * &#91;Required&#93; Specifies the method request's HTTP method type.
     */
    val httpMethod: kotlin.String? = builder.httpMethod
    /**
     * A human-friendly operation identifier for the method. For example, you can assign the `operationName` of `ListPets` for the `GET /pets` method in the `PetStore` example.
     */
    val operationName: kotlin.String? = builder.operationName
    /**
     * Specifies the Model resources used for the request's content type. Request models are represented as a key/value map, with a content type as the key and a Model name as the value.
     */
    val requestModels: Map<String, String>? = builder.requestModels
    /**
     * A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key defines a method request parameter name matching the pattern of `method.request.{location}.{name}`, where `location` is `querystring`, `path`, or `header` and `name` is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (`true`) or optional (`false`). The method request parameter names defined here are available in Integration to be mapped to integration request parameters or body-mapping templates.
     */
    val requestParameters: Map<String, Boolean>? = builder.requestParameters
    /**
     * The identifier of a RequestValidator for validating the method request.
     */
    val requestValidatorId: kotlin.String? = builder.requestValidatorId
    /**
     * &#91;Required&#93; The Resource identifier for the new Method resource.
     */
    val resourceId: kotlin.String? = builder.resourceId
    /**
     * &#91;Required&#93; The string identifier of the associated RestApi.
     */
    val restApiId: kotlin.String? = builder.restApiId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.PutMethodRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutMethodRequest(")
        append("apiKeyRequired=$apiKeyRequired,")
        append("authorizationScopes=$authorizationScopes,")
        append("authorizationType=$authorizationType,")
        append("authorizerId=$authorizerId,")
        append("httpMethod=$httpMethod,")
        append("operationName=$operationName,")
        append("requestModels=$requestModels,")
        append("requestParameters=$requestParameters,")
        append("requestValidatorId=$requestValidatorId,")
        append("resourceId=$resourceId,")
        append("restApiId=$restApiId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiKeyRequired.hashCode()
        result = 31 * result + (authorizationScopes?.hashCode() ?: 0)
        result = 31 * result + (authorizationType?.hashCode() ?: 0)
        result = 31 * result + (authorizerId?.hashCode() ?: 0)
        result = 31 * result + (httpMethod?.hashCode() ?: 0)
        result = 31 * result + (operationName?.hashCode() ?: 0)
        result = 31 * result + (requestModels?.hashCode() ?: 0)
        result = 31 * result + (requestParameters?.hashCode() ?: 0)
        result = 31 * result + (requestValidatorId?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutMethodRequest

        if (apiKeyRequired != other.apiKeyRequired) return false
        if (authorizationScopes != other.authorizationScopes) return false
        if (authorizationType != other.authorizationType) return false
        if (authorizerId != other.authorizerId) return false
        if (httpMethod != other.httpMethod) return false
        if (operationName != other.operationName) return false
        if (requestModels != other.requestModels) return false
        if (requestParameters != other.requestParameters) return false
        if (requestValidatorId != other.requestValidatorId) return false
        if (resourceId != other.resourceId) return false
        if (restApiId != other.restApiId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.PutMethodRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies whether the method required a valid ApiKey.
         */
        var apiKeyRequired: kotlin.Boolean = false
        /**
         * A list of authorization scopes configured on the method. The scopes are used with a `COGNITO_USER_POOLS` authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.
         */
        var authorizationScopes: List<String>? = null
        /**
         * &#91;Required&#93; The method's authorization type. Valid values are `NONE` for open access, `AWS_IAM` for using AWS IAM permissions, `CUSTOM` for using a custom authorizer, or `COGNITO_USER_POOLS` for using a Cognito user pool.
         */
        var authorizationType: kotlin.String? = null
        /**
         * Specifies the identifier of an Authorizer to use on this Method, if the type is CUSTOM or COGNITO_USER_POOLS. The authorizer identifier is generated by API Gateway when you created the authorizer.
         */
        var authorizerId: kotlin.String? = null
        /**
         * &#91;Required&#93; Specifies the method request's HTTP method type.
         */
        var httpMethod: kotlin.String? = null
        /**
         * A human-friendly operation identifier for the method. For example, you can assign the `operationName` of `ListPets` for the `GET /pets` method in the `PetStore` example.
         */
        var operationName: kotlin.String? = null
        /**
         * Specifies the Model resources used for the request's content type. Request models are represented as a key/value map, with a content type as the key and a Model name as the value.
         */
        var requestModels: Map<String, String>? = null
        /**
         * A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key defines a method request parameter name matching the pattern of `method.request.{location}.{name}`, where `location` is `querystring`, `path`, or `header` and `name` is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (`true`) or optional (`false`). The method request parameter names defined here are available in Integration to be mapped to integration request parameters or body-mapping templates.
         */
        var requestParameters: Map<String, Boolean>? = null
        /**
         * The identifier of a RequestValidator for validating the method request.
         */
        var requestValidatorId: kotlin.String? = null
        /**
         * &#91;Required&#93; The Resource identifier for the new Method resource.
         */
        var resourceId: kotlin.String? = null
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        var restApiId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.PutMethodRequest) : this() {
            this.apiKeyRequired = x.apiKeyRequired
            this.authorizationScopes = x.authorizationScopes
            this.authorizationType = x.authorizationType
            this.authorizerId = x.authorizerId
            this.httpMethod = x.httpMethod
            this.operationName = x.operationName
            this.requestModels = x.requestModels
            this.requestParameters = x.requestParameters
            this.requestValidatorId = x.requestValidatorId
            this.resourceId = x.resourceId
            this.restApiId = x.restApiId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.PutMethodRequest = PutMethodRequest(this)
    }
}
