// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Request to add a MethodResponse to an existing Method resource.
 */
class PutMethodResponseRequest private constructor(builder: Builder) {
    /**
     * &#91;Required&#93; The HTTP verb of the Method resource.
     */
    val httpMethod: kotlin.String? = builder.httpMethod
    /**
     * &#91;Required&#93; The Resource identifier for the Method resource.
     */
    val resourceId: kotlin.String? = builder.resourceId
    /**
     * Specifies the Model resources used for the response's content type. Response models are represented as a key/value map, with a content type as the key and a Model name as the value.
     */
    val responseModels: Map<String, String>? = builder.responseModels
    /**
     * A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header name and the associated value is a Boolean flag indicating whether the method response parameter is required or not. The method response header names must match the pattern of `method.response.header.{name}`, where `name` is a valid and unique header name. The response parameter names defined here are available in the integration response to be mapped from an integration response header expressed in `integration.response.header.{name}`, a static value enclosed within a pair of single quotes (e.g., `'application/json'`), or a JSON expression from the back-end response payload in the form of `integration.response.body.{JSON-expression}`, where `JSON-expression` is a valid JSON expression without the `$` prefix.)
     */
    val responseParameters: Map<String, Boolean>? = builder.responseParameters
    /**
     * &#91;Required&#93; The string identifier of the associated RestApi.
     */
    val restApiId: kotlin.String? = builder.restApiId
    /**
     * &#91;Required&#93; The method response's status code.
     */
    val statusCode: kotlin.String? = builder.statusCode

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.PutMethodResponseRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutMethodResponseRequest(")
        append("httpMethod=$httpMethod,")
        append("resourceId=$resourceId,")
        append("responseModels=$responseModels,")
        append("responseParameters=$responseParameters,")
        append("restApiId=$restApiId,")
        append("statusCode=$statusCode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = httpMethod?.hashCode() ?: 0
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (responseModels?.hashCode() ?: 0)
        result = 31 * result + (responseParameters?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        result = 31 * result + (statusCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutMethodResponseRequest

        if (httpMethod != other.httpMethod) return false
        if (resourceId != other.resourceId) return false
        if (responseModels != other.responseModels) return false
        if (responseParameters != other.responseParameters) return false
        if (restApiId != other.restApiId) return false
        if (statusCode != other.statusCode) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.PutMethodResponseRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * &#91;Required&#93; The HTTP verb of the Method resource.
         */
        var httpMethod: kotlin.String? = null
        /**
         * &#91;Required&#93; The Resource identifier for the Method resource.
         */
        var resourceId: kotlin.String? = null
        /**
         * Specifies the Model resources used for the response's content type. Response models are represented as a key/value map, with a content type as the key and a Model name as the value.
         */
        var responseModels: Map<String, String>? = null
        /**
         * A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header name and the associated value is a Boolean flag indicating whether the method response parameter is required or not. The method response header names must match the pattern of `method.response.header.{name}`, where `name` is a valid and unique header name. The response parameter names defined here are available in the integration response to be mapped from an integration response header expressed in `integration.response.header.{name}`, a static value enclosed within a pair of single quotes (e.g., `'application/json'`), or a JSON expression from the back-end response payload in the form of `integration.response.body.{JSON-expression}`, where `JSON-expression` is a valid JSON expression without the `$` prefix.)
         */
        var responseParameters: Map<String, Boolean>? = null
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        var restApiId: kotlin.String? = null
        /**
         * &#91;Required&#93; The method response's status code.
         */
        var statusCode: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.PutMethodResponseRequest) : this() {
            this.httpMethod = x.httpMethod
            this.resourceId = x.resourceId
            this.responseModels = x.responseModels
            this.responseParameters = x.responseParameters
            this.restApiId = x.restApiId
            this.statusCode = x.statusCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.PutMethodResponseRequest = PutMethodResponseRequest(this)
    }
}
