// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents a unique identifier for a version of a deployed RestApi that is callable by users.
 *
 * [Deploy an API](https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-deploy-api.html)
 */
class Stage private constructor(builder: Builder) {
    /**
     * Settings for logging access in this stage.
     */
    val accessLogSettings: aws.sdk.kotlin.services.apigateway.model.AccessLogSettings? = builder.accessLogSettings
    /**
     * Specifies whether a cache cluster is enabled for the stage.
     */
    val cacheClusterEnabled: kotlin.Boolean = builder.cacheClusterEnabled
    /**
     * The size of the cache cluster for the stage, if enabled.
     */
    val cacheClusterSize: aws.sdk.kotlin.services.apigateway.model.CacheClusterSize? = builder.cacheClusterSize
    /**
     * The status of the cache cluster for the stage, if enabled.
     */
    val cacheClusterStatus: aws.sdk.kotlin.services.apigateway.model.CacheClusterStatus? = builder.cacheClusterStatus
    /**
     * Settings for the canary deployment in this stage.
     */
    val canarySettings: aws.sdk.kotlin.services.apigateway.model.CanarySettings? = builder.canarySettings
    /**
     * The identifier of a client certificate for an API stage.
     */
    val clientCertificateId: kotlin.String? = builder.clientCertificateId
    /**
     * The timestamp when the stage was created.
     */
    val createdDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createdDate
    /**
     * The identifier of the Deployment that the stage points to.
     */
    val deploymentId: kotlin.String? = builder.deploymentId
    /**
     * The stage's description.
     */
    val description: kotlin.String? = builder.description
    /**
     * The version of the associated API documentation.
     */
    val documentationVersion: kotlin.String? = builder.documentationVersion
    /**
     * The timestamp when the stage last updated.
     */
    val lastUpdatedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDate
    /**
     * A map that defines the method settings for a Stage resource. Keys (designated as `/{method_setting_key` below) are method paths defined as `{resource_path}/{http_method}` for an individual method override, or `/\*&#47;\*` for overriding all methods in the stage. <#comment>
     */
    val methodSettings: Map<String, MethodSetting>? = builder.methodSettings
    /**
     * The name of the stage is the first path segment in the Uniform Resource Identifier (URI) of a call to API Gateway. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.
     */
    val stageName: kotlin.String? = builder.stageName
    /**
     * The collection of tags. Each tag element is associated with a given resource.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * Specifies whether active tracing with X-ray is enabled for the Stage.
     */
    val tracingEnabled: kotlin.Boolean = builder.tracingEnabled
    /**
     * A map that defines the stage variables for a Stage resource. Variable names can have alphanumeric and underscore characters, and the values must match `[A-Za-z0-9-._~:/?#&=,]+`.
     */
    val variables: Map<String, String>? = builder.variables
    /**
     * The ARN of the WebAcl associated with the Stage.
     */
    val webAclArn: kotlin.String? = builder.webAclArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.Stage = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Stage(")
        append("accessLogSettings=$accessLogSettings,")
        append("cacheClusterEnabled=$cacheClusterEnabled,")
        append("cacheClusterSize=$cacheClusterSize,")
        append("cacheClusterStatus=$cacheClusterStatus,")
        append("canarySettings=$canarySettings,")
        append("clientCertificateId=$clientCertificateId,")
        append("createdDate=$createdDate,")
        append("deploymentId=$deploymentId,")
        append("description=$description,")
        append("documentationVersion=$documentationVersion,")
        append("lastUpdatedDate=$lastUpdatedDate,")
        append("methodSettings=$methodSettings,")
        append("stageName=$stageName,")
        append("tags=$tags,")
        append("tracingEnabled=$tracingEnabled,")
        append("variables=$variables,")
        append("webAclArn=$webAclArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessLogSettings?.hashCode() ?: 0
        result = 31 * result + (cacheClusterEnabled.hashCode())
        result = 31 * result + (cacheClusterSize?.hashCode() ?: 0)
        result = 31 * result + (cacheClusterStatus?.hashCode() ?: 0)
        result = 31 * result + (canarySettings?.hashCode() ?: 0)
        result = 31 * result + (clientCertificateId?.hashCode() ?: 0)
        result = 31 * result + (createdDate?.hashCode() ?: 0)
        result = 31 * result + (deploymentId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (documentationVersion?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDate?.hashCode() ?: 0)
        result = 31 * result + (methodSettings?.hashCode() ?: 0)
        result = 31 * result + (stageName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tracingEnabled.hashCode())
        result = 31 * result + (variables?.hashCode() ?: 0)
        result = 31 * result + (webAclArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Stage

        if (accessLogSettings != other.accessLogSettings) return false
        if (cacheClusterEnabled != other.cacheClusterEnabled) return false
        if (cacheClusterSize != other.cacheClusterSize) return false
        if (cacheClusterStatus != other.cacheClusterStatus) return false
        if (canarySettings != other.canarySettings) return false
        if (clientCertificateId != other.clientCertificateId) return false
        if (createdDate != other.createdDate) return false
        if (deploymentId != other.deploymentId) return false
        if (description != other.description) return false
        if (documentationVersion != other.documentationVersion) return false
        if (lastUpdatedDate != other.lastUpdatedDate) return false
        if (methodSettings != other.methodSettings) return false
        if (stageName != other.stageName) return false
        if (tags != other.tags) return false
        if (tracingEnabled != other.tracingEnabled) return false
        if (variables != other.variables) return false
        if (webAclArn != other.webAclArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.Stage = Builder(this).apply(block).build()

    class Builder {
        /**
         * Settings for logging access in this stage.
         */
        var accessLogSettings: aws.sdk.kotlin.services.apigateway.model.AccessLogSettings? = null
        /**
         * Specifies whether a cache cluster is enabled for the stage.
         */
        var cacheClusterEnabled: kotlin.Boolean = false
        /**
         * The size of the cache cluster for the stage, if enabled.
         */
        var cacheClusterSize: aws.sdk.kotlin.services.apigateway.model.CacheClusterSize? = null
        /**
         * The status of the cache cluster for the stage, if enabled.
         */
        var cacheClusterStatus: aws.sdk.kotlin.services.apigateway.model.CacheClusterStatus? = null
        /**
         * Settings for the canary deployment in this stage.
         */
        var canarySettings: aws.sdk.kotlin.services.apigateway.model.CanarySettings? = null
        /**
         * The identifier of a client certificate for an API stage.
         */
        var clientCertificateId: kotlin.String? = null
        /**
         * The timestamp when the stage was created.
         */
        var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The identifier of the Deployment that the stage points to.
         */
        var deploymentId: kotlin.String? = null
        /**
         * The stage's description.
         */
        var description: kotlin.String? = null
        /**
         * The version of the associated API documentation.
         */
        var documentationVersion: kotlin.String? = null
        /**
         * The timestamp when the stage last updated.
         */
        var lastUpdatedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A map that defines the method settings for a Stage resource. Keys (designated as `/{method_setting_key` below) are method paths defined as `{resource_path}/{http_method}` for an individual method override, or `/\*&#47;\*` for overriding all methods in the stage. <#comment>
         */
        var methodSettings: Map<String, MethodSetting>? = null
        /**
         * The name of the stage is the first path segment in the Uniform Resource Identifier (URI) of a call to API Gateway. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.
         */
        var stageName: kotlin.String? = null
        /**
         * The collection of tags. Each tag element is associated with a given resource.
         */
        var tags: Map<String, String>? = null
        /**
         * Specifies whether active tracing with X-ray is enabled for the Stage.
         */
        var tracingEnabled: kotlin.Boolean = false
        /**
         * A map that defines the stage variables for a Stage resource. Variable names can have alphanumeric and underscore characters, and the values must match `[A-Za-z0-9-._~:/?#&=,]+`.
         */
        var variables: Map<String, String>? = null
        /**
         * The ARN of the WebAcl associated with the Stage.
         */
        var webAclArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.Stage) : this() {
            this.accessLogSettings = x.accessLogSettings
            this.cacheClusterEnabled = x.cacheClusterEnabled
            this.cacheClusterSize = x.cacheClusterSize
            this.cacheClusterStatus = x.cacheClusterStatus
            this.canarySettings = x.canarySettings
            this.clientCertificateId = x.clientCertificateId
            this.createdDate = x.createdDate
            this.deploymentId = x.deploymentId
            this.description = x.description
            this.documentationVersion = x.documentationVersion
            this.lastUpdatedDate = x.lastUpdatedDate
            this.methodSettings = x.methodSettings
            this.stageName = x.stageName
            this.tags = x.tags
            this.tracingEnabled = x.tracingEnabled
            this.variables = x.variables
            this.webAclArn = x.webAclArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.Stage = Stage(this)

        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.AccessLogSettings] inside the given [block]
         */
        fun accessLogSettings(block: aws.sdk.kotlin.services.apigateway.model.AccessLogSettings.Builder.() -> kotlin.Unit) {
            this.accessLogSettings = aws.sdk.kotlin.services.apigateway.model.AccessLogSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.CanarySettings] inside the given [block]
         */
        fun canarySettings(block: aws.sdk.kotlin.services.apigateway.model.CanarySettings.Builder.() -> kotlin.Unit) {
            this.canarySettings = aws.sdk.kotlin.services.apigateway.model.CanarySettings.invoke(block)
        }
    }
}
