// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Make a request to simulate the execution of an Authorizer.
 */
class TestInvokeAuthorizerRequest private constructor(builder: Builder) {
    /**
     * &#91;Optional&#93; A key-value map of additional context variables.
     */
    val additionalContext: Map<String, String>? = builder.additionalContext
    /**
     * &#91;Required&#93; Specifies a test invoke authorizer request's Authorizer ID.
     */
    val authorizerId: kotlin.String? = builder.authorizerId
    /**
     * &#91;Optional&#93; The simulated request body of an incoming invocation request.
     */
    val body: kotlin.String? = builder.body
    /**
     * &#91;Required&#93; A key-value map of headers to simulate an incoming invocation request. This is where the incoming authorization token, or identity source, should be specified.
     */
    val headers: Map<String, String>? = builder.headers
    /**
     * &#91;Optional&#93; The headers as a map from string to list of values to simulate an incoming invocation request. This is where the incoming authorization token, or identity source, may be specified.
     */
    val multiValueHeaders: Map<String, List<String>>? = builder.multiValueHeaders
    /**
     * &#91;Optional&#93; The URI path, including query string, of the simulated invocation request. Use this to specify path parameters and query string parameters.
     */
    val pathWithQueryString: kotlin.String? = builder.pathWithQueryString
    /**
     * &#91;Required&#93; The string identifier of the associated RestApi.
     */
    val restApiId: kotlin.String? = builder.restApiId
    /**
     * A key-value map of stage variables to simulate an invocation on a deployed Stage.
     */
    val stageVariables: Map<String, String>? = builder.stageVariables

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.TestInvokeAuthorizerRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TestInvokeAuthorizerRequest(")
        append("additionalContext=$additionalContext,")
        append("authorizerId=$authorizerId,")
        append("body=$body,")
        append("headers=$headers,")
        append("multiValueHeaders=$multiValueHeaders,")
        append("pathWithQueryString=$pathWithQueryString,")
        append("restApiId=$restApiId,")
        append("stageVariables=$stageVariables)")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalContext?.hashCode() ?: 0
        result = 31 * result + (authorizerId?.hashCode() ?: 0)
        result = 31 * result + (body?.hashCode() ?: 0)
        result = 31 * result + (headers?.hashCode() ?: 0)
        result = 31 * result + (multiValueHeaders?.hashCode() ?: 0)
        result = 31 * result + (pathWithQueryString?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        result = 31 * result + (stageVariables?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TestInvokeAuthorizerRequest

        if (additionalContext != other.additionalContext) return false
        if (authorizerId != other.authorizerId) return false
        if (body != other.body) return false
        if (headers != other.headers) return false
        if (multiValueHeaders != other.multiValueHeaders) return false
        if (pathWithQueryString != other.pathWithQueryString) return false
        if (restApiId != other.restApiId) return false
        if (stageVariables != other.stageVariables) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.TestInvokeAuthorizerRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * &#91;Optional&#93; A key-value map of additional context variables.
         */
        var additionalContext: Map<String, String>? = null
        /**
         * &#91;Required&#93; Specifies a test invoke authorizer request's Authorizer ID.
         */
        var authorizerId: kotlin.String? = null
        /**
         * &#91;Optional&#93; The simulated request body of an incoming invocation request.
         */
        var body: kotlin.String? = null
        /**
         * &#91;Required&#93; A key-value map of headers to simulate an incoming invocation request. This is where the incoming authorization token, or identity source, should be specified.
         */
        var headers: Map<String, String>? = null
        /**
         * &#91;Optional&#93; The headers as a map from string to list of values to simulate an incoming invocation request. This is where the incoming authorization token, or identity source, may be specified.
         */
        var multiValueHeaders: Map<String, List<String>>? = null
        /**
         * &#91;Optional&#93; The URI path, including query string, of the simulated invocation request. Use this to specify path parameters and query string parameters.
         */
        var pathWithQueryString: kotlin.String? = null
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        var restApiId: kotlin.String? = null
        /**
         * A key-value map of stage variables to simulate an invocation on a deployed Stage.
         */
        var stageVariables: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.TestInvokeAuthorizerRequest) : this() {
            this.additionalContext = x.additionalContext
            this.authorizerId = x.authorizerId
            this.body = x.body
            this.headers = x.headers
            this.multiValueHeaders = x.multiValueHeaders
            this.pathWithQueryString = x.pathWithQueryString
            this.restApiId = x.restApiId
            this.stageVariables = x.stageVariables
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.TestInvokeAuthorizerRequest = TestInvokeAuthorizerRequest(this)
    }
}
