// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Make a request to simulate the execution of a Method.
 */
class TestInvokeMethodRequest private constructor(builder: Builder) {
    /**
     * The simulated request body of an incoming invocation request.
     */
    val body: kotlin.String? = builder.body
    /**
     * A ClientCertificate identifier to use in the test invocation. API Gateway will use the certificate when making the HTTPS request to the defined back-end endpoint.
     */
    val clientCertificateId: kotlin.String? = builder.clientCertificateId
    /**
     * A key-value map of headers to simulate an incoming invocation request.
     */
    val headers: Map<String, String>? = builder.headers
    /**
     * &#91;Required&#93; Specifies a test invoke method request's HTTP method.
     */
    val httpMethod: kotlin.String? = builder.httpMethod
    /**
     * The headers as a map from string to list of values to simulate an incoming invocation request.
     */
    val multiValueHeaders: Map<String, List<String>>? = builder.multiValueHeaders
    /**
     * The URI path, including query string, of the simulated invocation request. Use this to specify path parameters and query string parameters.
     */
    val pathWithQueryString: kotlin.String? = builder.pathWithQueryString
    /**
     * &#91;Required&#93; Specifies a test invoke method request's resource ID.
     */
    val resourceId: kotlin.String? = builder.resourceId
    /**
     * &#91;Required&#93; The string identifier of the associated RestApi.
     */
    val restApiId: kotlin.String? = builder.restApiId
    /**
     * A key-value map of stage variables to simulate an invocation on a deployed Stage.
     */
    val stageVariables: Map<String, String>? = builder.stageVariables

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.TestInvokeMethodRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TestInvokeMethodRequest(")
        append("body=$body,")
        append("clientCertificateId=$clientCertificateId,")
        append("headers=$headers,")
        append("httpMethod=$httpMethod,")
        append("multiValueHeaders=$multiValueHeaders,")
        append("pathWithQueryString=$pathWithQueryString,")
        append("resourceId=$resourceId,")
        append("restApiId=$restApiId,")
        append("stageVariables=$stageVariables)")
    }

    override fun hashCode(): kotlin.Int {
        var result = body?.hashCode() ?: 0
        result = 31 * result + (clientCertificateId?.hashCode() ?: 0)
        result = 31 * result + (headers?.hashCode() ?: 0)
        result = 31 * result + (httpMethod?.hashCode() ?: 0)
        result = 31 * result + (multiValueHeaders?.hashCode() ?: 0)
        result = 31 * result + (pathWithQueryString?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        result = 31 * result + (stageVariables?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TestInvokeMethodRequest

        if (body != other.body) return false
        if (clientCertificateId != other.clientCertificateId) return false
        if (headers != other.headers) return false
        if (httpMethod != other.httpMethod) return false
        if (multiValueHeaders != other.multiValueHeaders) return false
        if (pathWithQueryString != other.pathWithQueryString) return false
        if (resourceId != other.resourceId) return false
        if (restApiId != other.restApiId) return false
        if (stageVariables != other.stageVariables) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.TestInvokeMethodRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The simulated request body of an incoming invocation request.
         */
        var body: kotlin.String? = null
        /**
         * A ClientCertificate identifier to use in the test invocation. API Gateway will use the certificate when making the HTTPS request to the defined back-end endpoint.
         */
        var clientCertificateId: kotlin.String? = null
        /**
         * A key-value map of headers to simulate an incoming invocation request.
         */
        var headers: Map<String, String>? = null
        /**
         * &#91;Required&#93; Specifies a test invoke method request's HTTP method.
         */
        var httpMethod: kotlin.String? = null
        /**
         * The headers as a map from string to list of values to simulate an incoming invocation request.
         */
        var multiValueHeaders: Map<String, List<String>>? = null
        /**
         * The URI path, including query string, of the simulated invocation request. Use this to specify path parameters and query string parameters.
         */
        var pathWithQueryString: kotlin.String? = null
        /**
         * &#91;Required&#93; Specifies a test invoke method request's resource ID.
         */
        var resourceId: kotlin.String? = null
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        var restApiId: kotlin.String? = null
        /**
         * A key-value map of stage variables to simulate an invocation on a deployed Stage.
         */
        var stageVariables: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.TestInvokeMethodRequest) : this() {
            this.body = x.body
            this.clientCertificateId = x.clientCertificateId
            this.headers = x.headers
            this.httpMethod = x.httpMethod
            this.multiValueHeaders = x.multiValueHeaders
            this.pathWithQueryString = x.pathWithQueryString
            this.resourceId = x.resourceId
            this.restApiId = x.restApiId
            this.stageVariables = x.stageVariables
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.TestInvokeMethodRequest = TestInvokeMethodRequest(this)
    }
}
