// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Represents the response of the test invoke request in the HTTP method.
 *
 * [Test API using the API Gateway console](https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-test-method.html#how-to-test-method-console)
 */
class TestInvokeMethodResponse private constructor(builder: Builder) {
    /**
     * The body of the HTTP response.
     */
    val body: kotlin.String? = builder.body
    /**
     * The headers of the HTTP response.
     */
    val headers: Map<String, String>? = builder.headers
    /**
     * The execution latency of the test invoke request.
     */
    val latency: kotlin.Long = builder.latency
    /**
     * The API Gateway execution log for the test invoke request.
     */
    val log: kotlin.String? = builder.log
    /**
     * The headers of the HTTP response as a map from string to list of values.
     */
    val multiValueHeaders: Map<String, List<String>>? = builder.multiValueHeaders
    /**
     * The HTTP status code.
     */
    val status: kotlin.Int = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.TestInvokeMethodResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TestInvokeMethodResponse(")
        append("body=$body,")
        append("headers=$headers,")
        append("latency=$latency,")
        append("log=$log,")
        append("multiValueHeaders=$multiValueHeaders,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = body?.hashCode() ?: 0
        result = 31 * result + (headers?.hashCode() ?: 0)
        result = 31 * result + (latency.hashCode())
        result = 31 * result + (log?.hashCode() ?: 0)
        result = 31 * result + (multiValueHeaders?.hashCode() ?: 0)
        result = 31 * result + (status)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TestInvokeMethodResponse

        if (body != other.body) return false
        if (headers != other.headers) return false
        if (latency != other.latency) return false
        if (log != other.log) return false
        if (multiValueHeaders != other.multiValueHeaders) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.TestInvokeMethodResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The body of the HTTP response.
         */
        var body: kotlin.String? = null
        /**
         * The headers of the HTTP response.
         */
        var headers: Map<String, String>? = null
        /**
         * The execution latency of the test invoke request.
         */
        var latency: kotlin.Long = 0L
        /**
         * The API Gateway execution log for the test invoke request.
         */
        var log: kotlin.String? = null
        /**
         * The headers of the HTTP response as a map from string to list of values.
         */
        var multiValueHeaders: Map<String, List<String>>? = null
        /**
         * The HTTP status code.
         */
        var status: kotlin.Int = 0

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.TestInvokeMethodResponse) : this() {
            this.body = x.body
            this.headers = x.headers
            this.latency = x.latency
            this.log = x.log
            this.multiValueHeaders = x.multiValueHeaders
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.TestInvokeMethodResponse = TestInvokeMethodResponse(this)
    }
}
