// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A resource that can be distributed to callers for executing Method resources that require an API key. API keys can be mapped to any Stage on any RestApi, which indicates that the callers with the API key can make requests to that stage.
 *
 * [Use API Keys](https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-api-keys.html)
 */
class UpdateApiKeyResponse private constructor(builder: Builder) {
    /**
     * The timestamp when the API Key was created.
     */
    val createdDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createdDate
    /**
     * An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.
     */
    val customerId: kotlin.String? = builder.customerId
    /**
     * The description of the API Key.
     */
    val description: kotlin.String? = builder.description
    /**
     * Specifies whether the API Key can be used by callers.
     */
    val enabled: kotlin.Boolean = builder.enabled
    /**
     * The identifier of the API Key.
     */
    val id: kotlin.String? = builder.id
    /**
     * The timestamp when the API Key was last updated.
     */
    val lastUpdatedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDate
    /**
     * The name of the API Key.
     */
    val name: kotlin.String? = builder.name
    /**
     * A list of Stage resources that are associated with the ApiKey resource.
     */
    val stageKeys: List<String>? = builder.stageKeys
    /**
     * The collection of tags. Each tag element is associated with a given resource.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The value of the API Key.
     */
    val value: kotlin.String? = builder.value

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.UpdateApiKeyResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateApiKeyResponse(")
        append("createdDate=$createdDate,")
        append("customerId=$customerId,")
        append("description=$description,")
        append("enabled=$enabled,")
        append("id=$id,")
        append("lastUpdatedDate=$lastUpdatedDate,")
        append("name=$name,")
        append("stageKeys=$stageKeys,")
        append("tags=$tags,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdDate?.hashCode() ?: 0
        result = 31 * result + (customerId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (enabled.hashCode())
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDate?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (stageKeys?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateApiKeyResponse

        if (createdDate != other.createdDate) return false
        if (customerId != other.customerId) return false
        if (description != other.description) return false
        if (enabled != other.enabled) return false
        if (id != other.id) return false
        if (lastUpdatedDate != other.lastUpdatedDate) return false
        if (name != other.name) return false
        if (stageKeys != other.stageKeys) return false
        if (tags != other.tags) return false
        if (value != other.value) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.UpdateApiKeyResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The timestamp when the API Key was created.
         */
        var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.
         */
        var customerId: kotlin.String? = null
        /**
         * The description of the API Key.
         */
        var description: kotlin.String? = null
        /**
         * Specifies whether the API Key can be used by callers.
         */
        var enabled: kotlin.Boolean = false
        /**
         * The identifier of the API Key.
         */
        var id: kotlin.String? = null
        /**
         * The timestamp when the API Key was last updated.
         */
        var lastUpdatedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the API Key.
         */
        var name: kotlin.String? = null
        /**
         * A list of Stage resources that are associated with the ApiKey resource.
         */
        var stageKeys: List<String>? = null
        /**
         * The collection of tags. Each tag element is associated with a given resource.
         */
        var tags: Map<String, String>? = null
        /**
         * The value of the API Key.
         */
        var value: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.UpdateApiKeyResponse) : this() {
            this.createdDate = x.createdDate
            this.customerId = x.customerId
            this.description = x.description
            this.enabled = x.enabled
            this.id = x.id
            this.lastUpdatedDate = x.lastUpdatedDate
            this.name = x.name
            this.stageKeys = x.stageKeys
            this.tags = x.tags
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.UpdateApiKeyResponse = UpdateApiKeyResponse(this)
    }
}
