// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Represents the base path that callers of the API must provide as part of the URL after the domain name.
 *
 * A custom domain name plus a `BasePathMapping` specification identifies a deployed RestApi in a given stage of the owner Account.
 *
 * [Use Custom Domain Names](https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-custom-domains.html)
 */
class UpdateBasePathMappingResponse private constructor(builder: Builder) {
    /**
     * The base path name that callers of the API must provide as part of the URL after the domain name.
     */
    val basePath: kotlin.String? = builder.basePath
    /**
     * The string identifier of the associated RestApi.
     */
    val restApiId: kotlin.String? = builder.restApiId
    /**
     * The name of the associated stage.
     */
    val stage: kotlin.String? = builder.stage

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.UpdateBasePathMappingResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateBasePathMappingResponse(")
        append("basePath=$basePath,")
        append("restApiId=$restApiId,")
        append("stage=$stage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = basePath?.hashCode() ?: 0
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        result = 31 * result + (stage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateBasePathMappingResponse

        if (basePath != other.basePath) return false
        if (restApiId != other.restApiId) return false
        if (stage != other.stage) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.UpdateBasePathMappingResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The base path name that callers of the API must provide as part of the URL after the domain name.
         */
        var basePath: kotlin.String? = null
        /**
         * The string identifier of the associated RestApi.
         */
        var restApiId: kotlin.String? = null
        /**
         * The name of the associated stage.
         */
        var stage: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.UpdateBasePathMappingResponse) : this() {
            this.basePath = x.basePath
            this.restApiId = x.restApiId
            this.stage = x.stage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.UpdateBasePathMappingResponse = UpdateBasePathMappingResponse(this)
    }
}
