// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents a client certificate used to configure client-side SSL authentication while sending requests to the integration endpoint.
 *
 * Client certificates are used to authenticate an API by the backend server. To authenticate an API client (or user), use IAM roles and policies, a custom Authorizer or an Amazon Cognito user pool.
 *
 * [Use Client-Side Certificate](https://docs.aws.amazon.com/apigateway/latest/developerguide/getting-started-client-side-ssl-authentication.html)
 */
class UpdateClientCertificateResponse private constructor(builder: Builder) {
    /**
     * The identifier of the client certificate.
     */
    val clientCertificateId: kotlin.String? = builder.clientCertificateId
    /**
     * The timestamp when the client certificate was created.
     */
    val createdDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createdDate
    /**
     * The description of the client certificate.
     */
    val description: kotlin.String? = builder.description
    /**
     * The timestamp when the client certificate will expire.
     */
    val expirationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.expirationDate
    /**
     * The PEM-encoded public key of the client certificate, which can be used to configure certificate authentication in the integration endpoint .
     */
    val pemEncodedCertificate: kotlin.String? = builder.pemEncodedCertificate
    /**
     * The collection of tags. Each tag element is associated with a given resource.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.UpdateClientCertificateResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateClientCertificateResponse(")
        append("clientCertificateId=$clientCertificateId,")
        append("createdDate=$createdDate,")
        append("description=$description,")
        append("expirationDate=$expirationDate,")
        append("pemEncodedCertificate=$pemEncodedCertificate,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientCertificateId?.hashCode() ?: 0
        result = 31 * result + (createdDate?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (expirationDate?.hashCode() ?: 0)
        result = 31 * result + (pemEncodedCertificate?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateClientCertificateResponse

        if (clientCertificateId != other.clientCertificateId) return false
        if (createdDate != other.createdDate) return false
        if (description != other.description) return false
        if (expirationDate != other.expirationDate) return false
        if (pemEncodedCertificate != other.pemEncodedCertificate) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.UpdateClientCertificateResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The identifier of the client certificate.
         */
        var clientCertificateId: kotlin.String? = null
        /**
         * The timestamp when the client certificate was created.
         */
        var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the client certificate.
         */
        var description: kotlin.String? = null
        /**
         * The timestamp when the client certificate will expire.
         */
        var expirationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The PEM-encoded public key of the client certificate, which can be used to configure certificate authentication in the integration endpoint .
         */
        var pemEncodedCertificate: kotlin.String? = null
        /**
         * The collection of tags. Each tag element is associated with a given resource.
         */
        var tags: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.UpdateClientCertificateResponse) : this() {
            this.clientCertificateId = x.clientCertificateId
            this.createdDate = x.createdDate
            this.description = x.description
            this.expirationDate = x.expirationDate
            this.pemEncodedCertificate = x.pemEncodedCertificate
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.UpdateClientCertificateResponse = UpdateClientCertificateResponse(this)
    }
}
