// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * A set of validation rules for incoming Method requests.
 *
 * In OpenAPI, a RequestValidator of an API is defined by the [x-amazon-apigateway-request-validators.requestValidator](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions.html#api-gateway-swagger-extensions-request-validators.requestValidator.html) object. It the referenced using the [x-amazon-apigateway-request-validator](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions.html#api-gateway-swagger-extensions-request-validator) property.
 *
 * [Enable Basic Request Validation in API Gateway](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-method-request-validation.html)
 */
class UpdateRequestValidatorResponse private constructor(builder: Builder) {
    /**
     * The identifier of this RequestValidator.
     */
    val id: kotlin.String? = builder.id
    /**
     * The name of this RequestValidator
     */
    val name: kotlin.String? = builder.name
    /**
     * A Boolean flag to indicate whether to validate a request body according to the configured Model schema.
     */
    val validateRequestBody: kotlin.Boolean = builder.validateRequestBody
    /**
     * A Boolean flag to indicate whether to validate request parameters (`true`) or not (`false`).
     */
    val validateRequestParameters: kotlin.Boolean = builder.validateRequestParameters

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.UpdateRequestValidatorResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateRequestValidatorResponse(")
        append("id=$id,")
        append("name=$name,")
        append("validateRequestBody=$validateRequestBody,")
        append("validateRequestParameters=$validateRequestParameters)")
    }

    override fun hashCode(): kotlin.Int {
        var result = id?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (validateRequestBody.hashCode())
        result = 31 * result + (validateRequestParameters.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateRequestValidatorResponse

        if (id != other.id) return false
        if (name != other.name) return false
        if (validateRequestBody != other.validateRequestBody) return false
        if (validateRequestParameters != other.validateRequestParameters) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.UpdateRequestValidatorResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The identifier of this RequestValidator.
         */
        var id: kotlin.String? = null
        /**
         * The name of this RequestValidator
         */
        var name: kotlin.String? = null
        /**
         * A Boolean flag to indicate whether to validate a request body according to the configured Model schema.
         */
        var validateRequestBody: kotlin.Boolean = false
        /**
         * A Boolean flag to indicate whether to validate request parameters (`true`) or not (`false`).
         */
        var validateRequestParameters: kotlin.Boolean = false

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.UpdateRequestValidatorResponse) : this() {
            this.id = x.id
            this.name = x.name
            this.validateRequestBody = x.validateRequestBody
            this.validateRequestParameters = x.validateRequestParameters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.UpdateRequestValidatorResponse = UpdateRequestValidatorResponse(this)
    }
}
