// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.paginators

import aws.sdk.kotlin.services.apigateway.ApiGatewayClient
import aws.sdk.kotlin.services.apigateway.model.ApiKey
import aws.sdk.kotlin.services.apigateway.model.BasePathMapping
import aws.sdk.kotlin.services.apigateway.model.ClientCertificate
import aws.sdk.kotlin.services.apigateway.model.Deployment
import aws.sdk.kotlin.services.apigateway.model.DomainName
import aws.sdk.kotlin.services.apigateway.model.GetApiKeysRequest
import aws.sdk.kotlin.services.apigateway.model.GetApiKeysResponse
import aws.sdk.kotlin.services.apigateway.model.GetBasePathMappingsRequest
import aws.sdk.kotlin.services.apigateway.model.GetBasePathMappingsResponse
import aws.sdk.kotlin.services.apigateway.model.GetClientCertificatesRequest
import aws.sdk.kotlin.services.apigateway.model.GetClientCertificatesResponse
import aws.sdk.kotlin.services.apigateway.model.GetDeploymentsRequest
import aws.sdk.kotlin.services.apigateway.model.GetDeploymentsResponse
import aws.sdk.kotlin.services.apigateway.model.GetDomainNamesRequest
import aws.sdk.kotlin.services.apigateway.model.GetDomainNamesResponse
import aws.sdk.kotlin.services.apigateway.model.GetModelsRequest
import aws.sdk.kotlin.services.apigateway.model.GetModelsResponse
import aws.sdk.kotlin.services.apigateway.model.GetResourcesRequest
import aws.sdk.kotlin.services.apigateway.model.GetResourcesResponse
import aws.sdk.kotlin.services.apigateway.model.GetRestApisRequest
import aws.sdk.kotlin.services.apigateway.model.GetRestApisResponse
import aws.sdk.kotlin.services.apigateway.model.GetUsagePlanKeysRequest
import aws.sdk.kotlin.services.apigateway.model.GetUsagePlanKeysResponse
import aws.sdk.kotlin.services.apigateway.model.GetUsagePlansRequest
import aws.sdk.kotlin.services.apigateway.model.GetUsagePlansResponse
import aws.sdk.kotlin.services.apigateway.model.GetUsageRequest
import aws.sdk.kotlin.services.apigateway.model.GetUsageResponse
import aws.sdk.kotlin.services.apigateway.model.GetVpcLinksRequest
import aws.sdk.kotlin.services.apigateway.model.GetVpcLinksResponse
import aws.sdk.kotlin.services.apigateway.model.Model
import aws.sdk.kotlin.services.apigateway.model.Resource
import aws.sdk.kotlin.services.apigateway.model.RestApi
import aws.sdk.kotlin.services.apigateway.model.UsagePlan
import aws.sdk.kotlin.services.apigateway.model.UsagePlanKey
import aws.sdk.kotlin.services.apigateway.model.VpcLink
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [GetApiKeysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetApiKeysRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetApiKeysResponse]
 */
fun ApiGatewayClient.getApiKeysPaginated(initialRequest: GetApiKeysRequest): Flow<GetApiKeysResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.position = cursor
            }
            val result = this@getApiKeysPaginated.getApiKeys(req)
            isFirstPage = false
            cursor = result.position
            emit(result)
        }
    }

/**
 * Paginate over [GetApiKeysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetApiKeysResponse]
 */
fun ApiGatewayClient.getApiKeysPaginated(block: GetApiKeysRequest.Builder.() -> Unit): Flow<GetApiKeysResponse> =
    getApiKeysPaginated(GetApiKeysRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getApiKeysPaginated]
 * to access the nested member [ApiKey]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ApiKey]
 */
@JvmName("getApiKeysResponseApiKey")
fun Flow<GetApiKeysResponse>.items(): Flow<ApiKey> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetBasePathMappingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetBasePathMappingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetBasePathMappingsResponse]
 */
fun ApiGatewayClient.getBasePathMappingsPaginated(initialRequest: GetBasePathMappingsRequest): Flow<GetBasePathMappingsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.position = cursor
            }
            val result = this@getBasePathMappingsPaginated.getBasePathMappings(req)
            isFirstPage = false
            cursor = result.position
            emit(result)
        }
    }

/**
 * Paginate over [GetBasePathMappingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetBasePathMappingsResponse]
 */
fun ApiGatewayClient.getBasePathMappingsPaginated(block: GetBasePathMappingsRequest.Builder.() -> Unit): Flow<GetBasePathMappingsResponse> =
    getBasePathMappingsPaginated(GetBasePathMappingsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getBasePathMappingsPaginated]
 * to access the nested member [BasePathMapping]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [BasePathMapping]
 */
@JvmName("getBasePathMappingsResponseBasePathMapping")
fun Flow<GetBasePathMappingsResponse>.items(): Flow<BasePathMapping> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetClientCertificatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetClientCertificatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetClientCertificatesResponse]
 */
fun ApiGatewayClient.getClientCertificatesPaginated(initialRequest: GetClientCertificatesRequest): Flow<GetClientCertificatesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.position = cursor
            }
            val result = this@getClientCertificatesPaginated.getClientCertificates(req)
            isFirstPage = false
            cursor = result.position
            emit(result)
        }
    }

/**
 * Paginate over [GetClientCertificatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetClientCertificatesResponse]
 */
fun ApiGatewayClient.getClientCertificatesPaginated(block: GetClientCertificatesRequest.Builder.() -> Unit): Flow<GetClientCertificatesResponse> =
    getClientCertificatesPaginated(GetClientCertificatesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getClientCertificatesPaginated]
 * to access the nested member [ClientCertificate]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ClientCertificate]
 */
@JvmName("getClientCertificatesResponseClientCertificate")
fun Flow<GetClientCertificatesResponse>.items(): Flow<ClientCertificate> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetDeploymentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetDeploymentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetDeploymentsResponse]
 */
fun ApiGatewayClient.getDeploymentsPaginated(initialRequest: GetDeploymentsRequest): Flow<GetDeploymentsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.position = cursor
            }
            val result = this@getDeploymentsPaginated.getDeployments(req)
            isFirstPage = false
            cursor = result.position
            emit(result)
        }
    }

/**
 * Paginate over [GetDeploymentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetDeploymentsResponse]
 */
fun ApiGatewayClient.getDeploymentsPaginated(block: GetDeploymentsRequest.Builder.() -> Unit): Flow<GetDeploymentsResponse> =
    getDeploymentsPaginated(GetDeploymentsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getDeploymentsPaginated]
 * to access the nested member [Deployment]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Deployment]
 */
@JvmName("getDeploymentsResponseDeployment")
fun Flow<GetDeploymentsResponse>.items(): Flow<Deployment> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetDomainNamesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetDomainNamesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetDomainNamesResponse]
 */
fun ApiGatewayClient.getDomainNamesPaginated(initialRequest: GetDomainNamesRequest): Flow<GetDomainNamesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.position = cursor
            }
            val result = this@getDomainNamesPaginated.getDomainNames(req)
            isFirstPage = false
            cursor = result.position
            emit(result)
        }
    }

/**
 * Paginate over [GetDomainNamesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetDomainNamesResponse]
 */
fun ApiGatewayClient.getDomainNamesPaginated(block: GetDomainNamesRequest.Builder.() -> Unit): Flow<GetDomainNamesResponse> =
    getDomainNamesPaginated(GetDomainNamesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getDomainNamesPaginated]
 * to access the nested member [DomainName]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DomainName]
 */
@JvmName("getDomainNamesResponseDomainName")
fun Flow<GetDomainNamesResponse>.items(): Flow<DomainName> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetModelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetModelsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetModelsResponse]
 */
fun ApiGatewayClient.getModelsPaginated(initialRequest: GetModelsRequest): Flow<GetModelsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.position = cursor
            }
            val result = this@getModelsPaginated.getModels(req)
            isFirstPage = false
            cursor = result.position
            emit(result)
        }
    }

/**
 * Paginate over [GetModelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetModelsResponse]
 */
fun ApiGatewayClient.getModelsPaginated(block: GetModelsRequest.Builder.() -> Unit): Flow<GetModelsResponse> =
    getModelsPaginated(GetModelsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getModelsPaginated]
 * to access the nested member [Model]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Model]
 */
@JvmName("getModelsResponseModel")
fun Flow<GetModelsResponse>.items(): Flow<Model> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetResourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetResourcesResponse]
 */
fun ApiGatewayClient.getResourcesPaginated(initialRequest: GetResourcesRequest): Flow<GetResourcesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.position = cursor
            }
            val result = this@getResourcesPaginated.getResources(req)
            isFirstPage = false
            cursor = result.position
            emit(result)
        }
    }

/**
 * Paginate over [GetResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetResourcesResponse]
 */
fun ApiGatewayClient.getResourcesPaginated(block: GetResourcesRequest.Builder.() -> Unit): Flow<GetResourcesResponse> =
    getResourcesPaginated(GetResourcesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getResourcesPaginated]
 * to access the nested member [Resource]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Resource]
 */
@JvmName("getResourcesResponseResource")
fun Flow<GetResourcesResponse>.items(): Flow<Resource> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetRestApisResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetRestApisRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetRestApisResponse]
 */
fun ApiGatewayClient.getRestApisPaginated(initialRequest: GetRestApisRequest): Flow<GetRestApisResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.position = cursor
            }
            val result = this@getRestApisPaginated.getRestApis(req)
            isFirstPage = false
            cursor = result.position
            emit(result)
        }
    }

/**
 * Paginate over [GetRestApisResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetRestApisResponse]
 */
fun ApiGatewayClient.getRestApisPaginated(block: GetRestApisRequest.Builder.() -> Unit): Flow<GetRestApisResponse> =
    getRestApisPaginated(GetRestApisRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getRestApisPaginated]
 * to access the nested member [RestApi]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RestApi]
 */
@JvmName("getRestApisResponseRestApi")
fun Flow<GetRestApisResponse>.items(): Flow<RestApi> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetUsageResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetUsageRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetUsageResponse]
 */
fun ApiGatewayClient.getUsagePaginated(initialRequest: GetUsageRequest): Flow<GetUsageResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.position = cursor
            }
            val result = this@getUsagePaginated.getUsage(req)
            isFirstPage = false
            cursor = result.position
            emit(result)
        }
    }

/**
 * Paginate over [GetUsageResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetUsageResponse]
 */
fun ApiGatewayClient.getUsagePaginated(block: GetUsageRequest.Builder.() -> Unit): Flow<GetUsageResponse> =
    getUsagePaginated(GetUsageRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getUsagePaginated]
 * to access the nested member [MapOfKeyUsages]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [MapOfKeyUsages]
 */
@JvmName("getUsageResponseMapOfKeyUsages")
fun Flow<GetUsageResponse>.items(): Flow<Map.Entry<String, List<List<Long>>>> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetUsagePlanKeysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetUsagePlanKeysRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetUsagePlanKeysResponse]
 */
fun ApiGatewayClient.getUsagePlanKeysPaginated(initialRequest: GetUsagePlanKeysRequest): Flow<GetUsagePlanKeysResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.position = cursor
            }
            val result = this@getUsagePlanKeysPaginated.getUsagePlanKeys(req)
            isFirstPage = false
            cursor = result.position
            emit(result)
        }
    }

/**
 * Paginate over [GetUsagePlanKeysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetUsagePlanKeysResponse]
 */
fun ApiGatewayClient.getUsagePlanKeysPaginated(block: GetUsagePlanKeysRequest.Builder.() -> Unit): Flow<GetUsagePlanKeysResponse> =
    getUsagePlanKeysPaginated(GetUsagePlanKeysRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getUsagePlanKeysPaginated]
 * to access the nested member [UsagePlanKey]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [UsagePlanKey]
 */
@JvmName("getUsagePlanKeysResponseUsagePlanKey")
fun Flow<GetUsagePlanKeysResponse>.items(): Flow<UsagePlanKey> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetUsagePlansResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetUsagePlansRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetUsagePlansResponse]
 */
fun ApiGatewayClient.getUsagePlansPaginated(initialRequest: GetUsagePlansRequest): Flow<GetUsagePlansResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.position = cursor
            }
            val result = this@getUsagePlansPaginated.getUsagePlans(req)
            isFirstPage = false
            cursor = result.position
            emit(result)
        }
    }

/**
 * Paginate over [GetUsagePlansResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetUsagePlansResponse]
 */
fun ApiGatewayClient.getUsagePlansPaginated(block: GetUsagePlansRequest.Builder.() -> Unit): Flow<GetUsagePlansResponse> =
    getUsagePlansPaginated(GetUsagePlansRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getUsagePlansPaginated]
 * to access the nested member [UsagePlan]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [UsagePlan]
 */
@JvmName("getUsagePlansResponseUsagePlan")
fun Flow<GetUsagePlansResponse>.items(): Flow<UsagePlan> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetVpcLinksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetVpcLinksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetVpcLinksResponse]
 */
fun ApiGatewayClient.getVpcLinksPaginated(initialRequest: GetVpcLinksRequest): Flow<GetVpcLinksResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.position = cursor
            }
            val result = this@getVpcLinksPaginated.getVpcLinks(req)
            isFirstPage = false
            cursor = result.position
            emit(result)
        }
    }

/**
 * Paginate over [GetVpcLinksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetVpcLinksResponse]
 */
fun ApiGatewayClient.getVpcLinksPaginated(block: GetVpcLinksRequest.Builder.() -> Unit): Flow<GetVpcLinksResponse> =
    getVpcLinksPaginated(GetVpcLinksRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getVpcLinksPaginated]
 * to access the nested member [VpcLink]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [VpcLink]
 */
@JvmName("getVpcLinksResponseVpcLink")
fun Flow<GetVpcLinksResponse>.items(): Flow<VpcLink> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }
