// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.apigateway.model.ApiGatewayException
import aws.sdk.kotlin.services.apigateway.model.ApiKeySourceType
import aws.sdk.kotlin.services.apigateway.model.EndpointConfiguration
import aws.sdk.kotlin.services.apigateway.model.UpdateRestApiResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class UpdateRestApiOperationDeserializer: HttpDeserialize<UpdateRestApiResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateRestApiResponse {
        if (!response.status.isSuccess()) {
            throwUpdateRestApiError(context, response)
        }
        val builder = UpdateRestApiResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateRestApiOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateRestApiError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ApiGatewayException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ApiGatewayException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateRestApiOperationBody(builder: UpdateRestApiResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APIKEYSOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("apiKeySource"))
    val BINARYMEDIATYPES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("binaryMediaTypes"))
    val CREATEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdDate"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val DISABLEEXECUTEAPIENDPOINT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("disableExecuteApiEndpoint"))
    val ENDPOINTCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("endpointConfiguration"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val MINIMUMCOMPRESSIONSIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("minimumCompressionSize"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val POLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("policy"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val VERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("version"))
    val WARNINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("warnings"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APIKEYSOURCE_DESCRIPTOR)
        field(BINARYMEDIATYPES_DESCRIPTOR)
        field(CREATEDDATE_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DISABLEEXECUTEAPIENDPOINT_DESCRIPTOR)
        field(ENDPOINTCONFIGURATION_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(MINIMUMCOMPRESSIONSIZE_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(POLICY_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(VERSION_DESCRIPTOR)
        field(WARNINGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APIKEYSOURCE_DESCRIPTOR.index -> builder.apiKeySource = deserializeString().let { ApiKeySourceType.fromValue(it) }
                BINARYMEDIATYPES_DESCRIPTOR.index -> builder.binaryMediaTypes =
                    deserializer.deserializeList(BINARYMEDIATYPES_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CREATEDDATE_DESCRIPTOR.index -> builder.createdDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                DISABLEEXECUTEAPIENDPOINT_DESCRIPTOR.index -> builder.disableExecuteApiEndpoint = deserializeBoolean()
                ENDPOINTCONFIGURATION_DESCRIPTOR.index -> builder.endpointConfiguration = deserializeEndpointConfigurationDocument(deserializer)
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                MINIMUMCOMPRESSIONSIZE_DESCRIPTOR.index -> builder.minimumCompressionSize = deserializeInt()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                POLICY_DESCRIPTOR.index -> builder.policy = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                VERSION_DESCRIPTOR.index -> builder.version = deserializeString()
                WARNINGS_DESCRIPTOR.index -> builder.warnings =
                    deserializer.deserializeList(WARNINGS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
