// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Represents a put integration response request.
 */
public class PutIntegrationResponseRequest private constructor(builder: Builder) {
    /**
     * Specifies how to handle response payload content type conversions. Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT`, with the following behaviors:
     *
     * If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.
     */
    public val contentHandling: aws.sdk.kotlin.services.apigateway.model.ContentHandlingStrategy? = builder.contentHandling
    /**
     * Specifies a put integration response request's HTTP method.
     */
    public val httpMethod: kotlin.String? = requireNotNull(builder.httpMethod) { "A non-null value must be provided for httpMethod" }
    /**
     * Specifies a put integration response request's resource identifier.
     */
    public val resourceId: kotlin.String? = requireNotNull(builder.resourceId) { "A non-null value must be provided for resourceId" }
    /**
     * A key-value map specifying response parameters that are passed to the method response from the back end. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of `method.response.header.{name}`, where `name` is a valid and unique header name. The mapped non-static value must match the pattern of `integration.response.header.{name}` or `integration.response.body.{JSON-expression}`, where `name` must be a valid and unique response header name and `JSON-expression` a valid JSON expression without the `$` prefix.
     */
    public val responseParameters: Map<String, String>? = builder.responseParameters
    /**
     * Specifies a put integration response's templates.
     */
    public val responseTemplates: Map<String, String>? = builder.responseTemplates
    /**
     * The string identifier of the associated RestApi.
     */
    public val restApiId: kotlin.String? = requireNotNull(builder.restApiId) { "A non-null value must be provided for restApiId" }
    /**
     * Specifies the selection pattern of a put integration response.
     */
    public val selectionPattern: kotlin.String? = builder.selectionPattern
    /**
     * Specifies the status code that is used to map the integration response to an existing MethodResponse.
     */
    public val statusCode: kotlin.String? = requireNotNull(builder.statusCode) { "A non-null value must be provided for statusCode" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.PutIntegrationResponseRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutIntegrationResponseRequest(")
        append("contentHandling=$contentHandling,")
        append("httpMethod=$httpMethod,")
        append("resourceId=$resourceId,")
        append("responseParameters=$responseParameters,")
        append("responseTemplates=$responseTemplates,")
        append("restApiId=$restApiId,")
        append("selectionPattern=$selectionPattern,")
        append("statusCode=$statusCode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = contentHandling?.hashCode() ?: 0
        result = 31 * result + (httpMethod?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (responseParameters?.hashCode() ?: 0)
        result = 31 * result + (responseTemplates?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        result = 31 * result + (selectionPattern?.hashCode() ?: 0)
        result = 31 * result + (statusCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutIntegrationResponseRequest

        if (contentHandling != other.contentHandling) return false
        if (httpMethod != other.httpMethod) return false
        if (resourceId != other.resourceId) return false
        if (responseParameters != other.responseParameters) return false
        if (responseTemplates != other.responseTemplates) return false
        if (restApiId != other.restApiId) return false
        if (selectionPattern != other.selectionPattern) return false
        if (statusCode != other.statusCode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.PutIntegrationResponseRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies how to handle response payload content type conversions. Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT`, with the following behaviors:
         *
         * If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.
         */
        public var contentHandling: aws.sdk.kotlin.services.apigateway.model.ContentHandlingStrategy? = null
        /**
         * Specifies a put integration response request's HTTP method.
         */
        public var httpMethod: kotlin.String? = null
        /**
         * Specifies a put integration response request's resource identifier.
         */
        public var resourceId: kotlin.String? = null
        /**
         * A key-value map specifying response parameters that are passed to the method response from the back end. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of `method.response.header.{name}`, where `name` is a valid and unique header name. The mapped non-static value must match the pattern of `integration.response.header.{name}` or `integration.response.body.{JSON-expression}`, where `name` must be a valid and unique response header name and `JSON-expression` a valid JSON expression without the `$` prefix.
         */
        public var responseParameters: Map<String, String>? = null
        /**
         * Specifies a put integration response's templates.
         */
        public var responseTemplates: Map<String, String>? = null
        /**
         * The string identifier of the associated RestApi.
         */
        public var restApiId: kotlin.String? = null
        /**
         * Specifies the selection pattern of a put integration response.
         */
        public var selectionPattern: kotlin.String? = null
        /**
         * Specifies the status code that is used to map the integration response to an existing MethodResponse.
         */
        public var statusCode: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.PutIntegrationResponseRequest) : this() {
            this.contentHandling = x.contentHandling
            this.httpMethod = x.httpMethod
            this.resourceId = x.resourceId
            this.responseParameters = x.responseParameters
            this.responseTemplates = x.responseTemplates
            this.restApiId = x.restApiId
            this.selectionPattern = x.selectionPattern
            this.statusCode = x.statusCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.PutIntegrationResponseRequest = PutIntegrationResponseRequest(this)
    }
}
