// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Make a request to simulate the invocation of an Authorizer.
 */
public class TestInvokeAuthorizerRequest private constructor(builder: Builder) {
    /**
     * A key-value map of additional context variables.
     */
    public val additionalContext: Map<String, String>? = builder.additionalContext
    /**
     * Specifies a test invoke authorizer request's Authorizer ID.
     */
    public val authorizerId: kotlin.String? = requireNotNull(builder.authorizerId) { "A non-null value must be provided for authorizerId" }
    /**
     * The simulated request body of an incoming invocation request.
     */
    public val body: kotlin.String? = builder.body
    /**
     * A key-value map of headers to simulate an incoming invocation request. This is where the incoming authorization token, or identity source, should be specified.
     */
    public val headers: Map<String, String>? = builder.headers
    /**
     * The headers as a map from string to list of values to simulate an incoming invocation request. This is where the incoming authorization token, or identity source, may be specified.
     */
    public val multiValueHeaders: Map<String, List<String>>? = builder.multiValueHeaders
    /**
     * The URI path, including query string, of the simulated invocation request. Use this to specify path parameters and query string parameters.
     */
    public val pathWithQueryString: kotlin.String? = builder.pathWithQueryString
    /**
     * The string identifier of the associated RestApi.
     */
    public val restApiId: kotlin.String? = requireNotNull(builder.restApiId) { "A non-null value must be provided for restApiId" }
    /**
     * A key-value map of stage variables to simulate an invocation on a deployed Stage.
     */
    public val stageVariables: Map<String, String>? = builder.stageVariables

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.TestInvokeAuthorizerRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TestInvokeAuthorizerRequest(")
        append("additionalContext=$additionalContext,")
        append("authorizerId=$authorizerId,")
        append("body=$body,")
        append("headers=$headers,")
        append("multiValueHeaders=$multiValueHeaders,")
        append("pathWithQueryString=$pathWithQueryString,")
        append("restApiId=$restApiId,")
        append("stageVariables=$stageVariables)")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalContext?.hashCode() ?: 0
        result = 31 * result + (authorizerId?.hashCode() ?: 0)
        result = 31 * result + (body?.hashCode() ?: 0)
        result = 31 * result + (headers?.hashCode() ?: 0)
        result = 31 * result + (multiValueHeaders?.hashCode() ?: 0)
        result = 31 * result + (pathWithQueryString?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        result = 31 * result + (stageVariables?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TestInvokeAuthorizerRequest

        if (additionalContext != other.additionalContext) return false
        if (authorizerId != other.authorizerId) return false
        if (body != other.body) return false
        if (headers != other.headers) return false
        if (multiValueHeaders != other.multiValueHeaders) return false
        if (pathWithQueryString != other.pathWithQueryString) return false
        if (restApiId != other.restApiId) return false
        if (stageVariables != other.stageVariables) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.TestInvokeAuthorizerRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A key-value map of additional context variables.
         */
        public var additionalContext: Map<String, String>? = null
        /**
         * Specifies a test invoke authorizer request's Authorizer ID.
         */
        public var authorizerId: kotlin.String? = null
        /**
         * The simulated request body of an incoming invocation request.
         */
        public var body: kotlin.String? = null
        /**
         * A key-value map of headers to simulate an incoming invocation request. This is where the incoming authorization token, or identity source, should be specified.
         */
        public var headers: Map<String, String>? = null
        /**
         * The headers as a map from string to list of values to simulate an incoming invocation request. This is where the incoming authorization token, or identity source, may be specified.
         */
        public var multiValueHeaders: Map<String, List<String>>? = null
        /**
         * The URI path, including query string, of the simulated invocation request. Use this to specify path parameters and query string parameters.
         */
        public var pathWithQueryString: kotlin.String? = null
        /**
         * The string identifier of the associated RestApi.
         */
        public var restApiId: kotlin.String? = null
        /**
         * A key-value map of stage variables to simulate an invocation on a deployed Stage.
         */
        public var stageVariables: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.TestInvokeAuthorizerRequest) : this() {
            this.additionalContext = x.additionalContext
            this.authorizerId = x.authorizerId
            this.body = x.body
            this.headers = x.headers
            this.multiValueHeaders = x.multiValueHeaders
            this.pathWithQueryString = x.pathWithQueryString
            this.restApiId = x.restApiId
            this.stageVariables = x.stageVariables
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.TestInvokeAuthorizerRequest = TestInvokeAuthorizerRequest(this)
    }
}
