// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.transform

import aws.sdk.kotlin.services.apigateway.model.CreateBasePathMappingRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateBasePathMappingOperationSerializer: HttpSerialize<CreateBasePathMappingRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateBasePathMappingRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "domainnames",
                "${input.domainName}".encodeLabel(),
                "basepathmappings",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateBasePathMappingOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateBasePathMappingOperationBody(context: ExecutionContext, input: CreateBasePathMappingRequest): ByteArray {
    val serializer = JsonSerializer()
    val BASEPATH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("basePath"))
    val RESTAPIID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("restApiId"))
    val STAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("stage"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BASEPATH_DESCRIPTOR)
        field(RESTAPIID_DESCRIPTOR)
        field(STAGE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.basePath?.let { field(BASEPATH_DESCRIPTOR, it) }
        input.restApiId?.let { field(RESTAPIID_DESCRIPTOR, it) }
        input.stage?.let { field(STAGE_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
