// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.transform

import aws.sdk.kotlin.services.apigateway.model.TestInvokeMethodRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class TestInvokeMethodOperationSerializer: HttpSerialize<TestInvokeMethodRequest> {
    override suspend fun serialize(context: ExecutionContext, input: TestInvokeMethodRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "restapis",
                "${input.restApiId}".encodeLabel(),
                "resources",
                "${input.resourceId}".encodeLabel(),
                "methods",
                "${input.httpMethod}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeTestInvokeMethodOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeTestInvokeMethodOperationBody(context: ExecutionContext, input: TestInvokeMethodRequest): ByteArray {
    val serializer = JsonSerializer()
    val BODY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("body"))
    val CLIENTCERTIFICATEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientCertificateId"))
    val HEADERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("headers"))
    val MULTIVALUEHEADERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("multiValueHeaders"))
    val MULTIVALUEHEADERS_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val PATHWITHQUERYSTRING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("pathWithQueryString"))
    val STAGEVARIABLES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("stageVariables"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BODY_DESCRIPTOR)
        field(CLIENTCERTIFICATEID_DESCRIPTOR)
        field(HEADERS_DESCRIPTOR)
        field(MULTIVALUEHEADERS_DESCRIPTOR)
        field(PATHWITHQUERYSTRING_DESCRIPTOR)
        field(STAGEVARIABLES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.body?.let { field(BODY_DESCRIPTOR, it) }
        input.clientCertificateId?.let { field(CLIENTCERTIFICATEID_DESCRIPTOR, it) }
        if (input.headers != null) {
            mapField(HEADERS_DESCRIPTOR) {
                input.headers.forEach { (key, value) -> entry(key, value) }
            }
        }
        if (input.multiValueHeaders != null) {
            mapField(MULTIVALUEHEADERS_DESCRIPTOR) {
                input.multiValueHeaders.forEach { (key, value) ->
                    listEntry(key, MULTIVALUEHEADERS_C0_DESCRIPTOR) {
                        for (el1 in value) {
                            serializeString(el1)
                        }
                    }
                }
            }
        }
        input.pathWithQueryString?.let { field(PATHWITHQUERYSTRING_DESCRIPTOR, it) }
        if (input.stageVariables != null) {
            mapField(STAGEVARIABLES_DESCRIPTOR) {
                input.stageVariables.forEach { (key, value) -> entry(key, value) }
            }
        }
    }
    return serializer.toByteArray()
}
