// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Request to list information about a collection of resources.
 */
public class GetResourcesRequest private constructor(builder: Builder) {
    /**
     * A query parameter used to retrieve the specified resources embedded in the returned Resources resource in the response. This `embed` parameter value is a list of comma-separated strings. Currently, the request supports only retrieval of the embedded Method resources this way. The query parameter value must be a single-valued list and contain the `"methods"` string. For example, `GET /restapis/{restapi_id}/resources?embed=methods`.
     */
    public val embed: List<String>? = builder.embed
    /**
     * The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
     */
    public val limit: kotlin.Int? = builder.limit
    /**
     * The current pagination position in the paged result set.
     */
    public val position: kotlin.String? = builder.position
    /**
     * The string identifier of the associated RestApi.
     */
    public val restApiId: kotlin.String? = requireNotNull(builder.restApiId) { "A non-null value must be provided for restApiId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.GetResourcesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetResourcesRequest(")
        append("embed=$embed,")
        append("limit=$limit,")
        append("position=$position,")
        append("restApiId=$restApiId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = embed?.hashCode() ?: 0
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (position?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetResourcesRequest

        if (embed != other.embed) return false
        if (limit != other.limit) return false
        if (position != other.position) return false
        if (restApiId != other.restApiId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.GetResourcesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A query parameter used to retrieve the specified resources embedded in the returned Resources resource in the response. This `embed` parameter value is a list of comma-separated strings. Currently, the request supports only retrieval of the embedded Method resources this way. The query parameter value must be a single-valued list and contain the `"methods"` string. For example, `GET /restapis/{restapi_id}/resources?embed=methods`.
         */
        public var embed: List<String>? = null
        /**
         * The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
         */
        public var limit: kotlin.Int? = null
        /**
         * The current pagination position in the paged result set.
         */
        public var position: kotlin.String? = null
        /**
         * The string identifier of the associated RestApi.
         */
        public var restApiId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.GetResourcesRequest) : this() {
            this.embed = x.embed
            this.limit = x.limit
            this.position = x.position
            this.restApiId = x.restApiId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.GetResourcesRequest = GetResourcesRequest(this)
    }
}
