// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * A PUT request to update an existing API, with external API definitions specified as the request body.
 */
public class PutRestApiRequest private constructor(builder: Builder) {
    /**
     * The PUT request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.
     */
    public val body: kotlin.ByteArray? = builder.body
    /**
     * A query parameter to indicate whether to rollback the API update (`true`) or not (`false`) when a warning is encountered. The default value is `false`.
     */
    public val failOnWarnings: kotlin.Boolean = builder.failOnWarnings
    /**
     * The `mode` query parameter to specify the update mode. Valid values are "merge" and "overwrite". By default, the update mode is "merge".
     */
    public val mode: aws.sdk.kotlin.services.apigateway.model.PutMode? = builder.mode
    /**
     * Custom header parameters as part of the request. For example, to exclude DocumentationParts from an imported API, set `ignore=documentation` as a `parameters` value, as in the AWS CLI command of `aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'`.
     */
    public val parameters: Map<String, String>? = builder.parameters
    /**
     * The string identifier of the associated RestApi.
     */
    public val restApiId: kotlin.String? = requireNotNull(builder.restApiId) { "A non-null value must be provided for restApiId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.PutRestApiRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutRestApiRequest(")
        append("body=$body,")
        append("failOnWarnings=$failOnWarnings,")
        append("mode=$mode,")
        append("parameters=$parameters,")
        append("restApiId=$restApiId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = body?.contentHashCode() ?: 0
        result = 31 * result + (failOnWarnings.hashCode())
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutRestApiRequest

        if (body != null) {
            if (other.body == null) return false
            if (!body.contentEquals(other.body)) return false
        } else if (other.body != null) return false
        if (failOnWarnings != other.failOnWarnings) return false
        if (mode != other.mode) return false
        if (parameters != other.parameters) return false
        if (restApiId != other.restApiId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.PutRestApiRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The PUT request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.
         */
        public var body: kotlin.ByteArray? = null
        /**
         * A query parameter to indicate whether to rollback the API update (`true`) or not (`false`) when a warning is encountered. The default value is `false`.
         */
        public var failOnWarnings: kotlin.Boolean = false
        /**
         * The `mode` query parameter to specify the update mode. Valid values are "merge" and "overwrite". By default, the update mode is "merge".
         */
        public var mode: aws.sdk.kotlin.services.apigateway.model.PutMode? = null
        /**
         * Custom header parameters as part of the request. For example, to exclude DocumentationParts from an imported API, set `ignore=documentation` as a `parameters` value, as in the AWS CLI command of `aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'`.
         */
        public var parameters: Map<String, String>? = null
        /**
         * The string identifier of the associated RestApi.
         */
        public var restApiId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.PutRestApiRequest) : this() {
            this.body = x.body
            this.failOnWarnings = x.failOnWarnings
            this.mode = x.mode
            this.parameters = x.parameters
            this.restApiId = x.restApiId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.PutRestApiRequest = PutRestApiRequest(this)
    }
}
