// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents a custom domain name as a user-friendly host name of an API (RestApi).
 */
public class UpdateDomainNameResponse private constructor(builder: Builder) {
    /**
     * The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.
     */
    public val certificateArn: kotlin.String? = builder.certificateArn
    /**
     * The name of the certificate that will be used by edge-optimized endpoint for this domain name.
     */
    public val certificateName: kotlin.String? = builder.certificateName
    /**
     * The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was uploaded.
     */
    public val certificateUploadDate: aws.smithy.kotlin.runtime.time.Instant? = builder.certificateUploadDate
    /**
     * The domain name of the Amazon CloudFront distribution associated with this custom domain name for an edge-optimized endpoint. You set up this association when adding a DNS record pointing the custom domain name to this distribution name. For more information about CloudFront distributions, see the Amazon CloudFront documentation.
     */
    public val distributionDomainName: kotlin.String? = builder.distributionDomainName
    /**
     * The region-agnostic Amazon Route 53 Hosted Zone ID of the edge-optimized endpoint. The valid value is `Z2FDTNDATAQYW2` for all the regions. For more information, see Set up a Regional Custom Domain Name and AWS Regions and Endpoints for API Gateway.
     */
    public val distributionHostedZoneId: kotlin.String? = builder.distributionHostedZoneId
    /**
     * The custom domain name as an API host name, for example, `my-api.example.com`.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * The status of the DomainName migration. The valid values are `AVAILABLE` and `UPDATING`. If the status is `UPDATING`, the domain cannot be modified further until the existing operation is complete. If it is `AVAILABLE`, the domain can be updated.
     */
    public val domainNameStatus: aws.sdk.kotlin.services.apigateway.model.DomainNameStatus? = builder.domainNameStatus
    /**
     * An optional text message containing detailed information about status of the DomainName migration.
     */
    public val domainNameStatusMessage: kotlin.String? = builder.domainNameStatusMessage
    /**
     * The endpoint configuration of this DomainName showing the endpoint types of the domain name.
     */
    public val endpointConfiguration: aws.sdk.kotlin.services.apigateway.model.EndpointConfiguration? = builder.endpointConfiguration
    /**
     * The mutual TLS authentication configuration for a custom domain name. If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your API.
     */
    public val mutualTlsAuthentication: aws.sdk.kotlin.services.apigateway.model.MutualTlsAuthentication? = builder.mutualTlsAuthentication
    /**
     * The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn.
     */
    public val ownershipVerificationCertificateArn: kotlin.String? = builder.ownershipVerificationCertificateArn
    /**
     * The reference to an AWS-managed certificate that will be used for validating the regional domain name. AWS Certificate Manager is the only supported source.
     */
    public val regionalCertificateArn: kotlin.String? = builder.regionalCertificateArn
    /**
     * The name of the certificate that will be used for validating the regional domain name.
     */
    public val regionalCertificateName: kotlin.String? = builder.regionalCertificateName
    /**
     * The domain name associated with the regional endpoint for this custom domain name. You set up this association by adding a DNS record that points the custom domain name to this regional domain name. The regional domain name is returned by API Gateway when you create a regional endpoint.
     */
    public val regionalDomainName: kotlin.String? = builder.regionalDomainName
    /**
     * The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint. For more information, see Set up a Regional Custom Domain Name and AWS Regions and Endpoints for API Gateway.
     */
    public val regionalHostedZoneId: kotlin.String? = builder.regionalHostedZoneId
    /**
     * The Transport Layer Security (TLS) version + cipher suite for this DomainName. The valid values are `TLS_1_0` and `TLS_1_2`.
     */
    public val securityPolicy: aws.sdk.kotlin.services.apigateway.model.SecurityPolicy? = builder.securityPolicy
    /**
     * The collection of tags. Each tag element is associated with a given resource.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.UpdateDomainNameResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateDomainNameResponse(")
        append("certificateArn=$certificateArn,")
        append("certificateName=$certificateName,")
        append("certificateUploadDate=$certificateUploadDate,")
        append("distributionDomainName=$distributionDomainName,")
        append("distributionHostedZoneId=$distributionHostedZoneId,")
        append("domainName=$domainName,")
        append("domainNameStatus=$domainNameStatus,")
        append("domainNameStatusMessage=$domainNameStatusMessage,")
        append("endpointConfiguration=$endpointConfiguration,")
        append("mutualTlsAuthentication=$mutualTlsAuthentication,")
        append("ownershipVerificationCertificateArn=$ownershipVerificationCertificateArn,")
        append("regionalCertificateArn=$regionalCertificateArn,")
        append("regionalCertificateName=$regionalCertificateName,")
        append("regionalDomainName=$regionalDomainName,")
        append("regionalHostedZoneId=$regionalHostedZoneId,")
        append("securityPolicy=$securityPolicy,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateArn?.hashCode() ?: 0
        result = 31 * result + (certificateName?.hashCode() ?: 0)
        result = 31 * result + (certificateUploadDate?.hashCode() ?: 0)
        result = 31 * result + (distributionDomainName?.hashCode() ?: 0)
        result = 31 * result + (distributionHostedZoneId?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (domainNameStatus?.hashCode() ?: 0)
        result = 31 * result + (domainNameStatusMessage?.hashCode() ?: 0)
        result = 31 * result + (endpointConfiguration?.hashCode() ?: 0)
        result = 31 * result + (mutualTlsAuthentication?.hashCode() ?: 0)
        result = 31 * result + (ownershipVerificationCertificateArn?.hashCode() ?: 0)
        result = 31 * result + (regionalCertificateArn?.hashCode() ?: 0)
        result = 31 * result + (regionalCertificateName?.hashCode() ?: 0)
        result = 31 * result + (regionalDomainName?.hashCode() ?: 0)
        result = 31 * result + (regionalHostedZoneId?.hashCode() ?: 0)
        result = 31 * result + (securityPolicy?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateDomainNameResponse

        if (certificateArn != other.certificateArn) return false
        if (certificateName != other.certificateName) return false
        if (certificateUploadDate != other.certificateUploadDate) return false
        if (distributionDomainName != other.distributionDomainName) return false
        if (distributionHostedZoneId != other.distributionHostedZoneId) return false
        if (domainName != other.domainName) return false
        if (domainNameStatus != other.domainNameStatus) return false
        if (domainNameStatusMessage != other.domainNameStatusMessage) return false
        if (endpointConfiguration != other.endpointConfiguration) return false
        if (mutualTlsAuthentication != other.mutualTlsAuthentication) return false
        if (ownershipVerificationCertificateArn != other.ownershipVerificationCertificateArn) return false
        if (regionalCertificateArn != other.regionalCertificateArn) return false
        if (regionalCertificateName != other.regionalCertificateName) return false
        if (regionalDomainName != other.regionalDomainName) return false
        if (regionalHostedZoneId != other.regionalHostedZoneId) return false
        if (securityPolicy != other.securityPolicy) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.UpdateDomainNameResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.
         */
        public var certificateArn: kotlin.String? = null
        /**
         * The name of the certificate that will be used by edge-optimized endpoint for this domain name.
         */
        public var certificateName: kotlin.String? = null
        /**
         * The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was uploaded.
         */
        public var certificateUploadDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The domain name of the Amazon CloudFront distribution associated with this custom domain name for an edge-optimized endpoint. You set up this association when adding a DNS record pointing the custom domain name to this distribution name. For more information about CloudFront distributions, see the Amazon CloudFront documentation.
         */
        public var distributionDomainName: kotlin.String? = null
        /**
         * The region-agnostic Amazon Route 53 Hosted Zone ID of the edge-optimized endpoint. The valid value is `Z2FDTNDATAQYW2` for all the regions. For more information, see Set up a Regional Custom Domain Name and AWS Regions and Endpoints for API Gateway.
         */
        public var distributionHostedZoneId: kotlin.String? = null
        /**
         * The custom domain name as an API host name, for example, `my-api.example.com`.
         */
        public var domainName: kotlin.String? = null
        /**
         * The status of the DomainName migration. The valid values are `AVAILABLE` and `UPDATING`. If the status is `UPDATING`, the domain cannot be modified further until the existing operation is complete. If it is `AVAILABLE`, the domain can be updated.
         */
        public var domainNameStatus: aws.sdk.kotlin.services.apigateway.model.DomainNameStatus? = null
        /**
         * An optional text message containing detailed information about status of the DomainName migration.
         */
        public var domainNameStatusMessage: kotlin.String? = null
        /**
         * The endpoint configuration of this DomainName showing the endpoint types of the domain name.
         */
        public var endpointConfiguration: aws.sdk.kotlin.services.apigateway.model.EndpointConfiguration? = null
        /**
         * The mutual TLS authentication configuration for a custom domain name. If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your API.
         */
        public var mutualTlsAuthentication: aws.sdk.kotlin.services.apigateway.model.MutualTlsAuthentication? = null
        /**
         * The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn.
         */
        public var ownershipVerificationCertificateArn: kotlin.String? = null
        /**
         * The reference to an AWS-managed certificate that will be used for validating the regional domain name. AWS Certificate Manager is the only supported source.
         */
        public var regionalCertificateArn: kotlin.String? = null
        /**
         * The name of the certificate that will be used for validating the regional domain name.
         */
        public var regionalCertificateName: kotlin.String? = null
        /**
         * The domain name associated with the regional endpoint for this custom domain name. You set up this association by adding a DNS record that points the custom domain name to this regional domain name. The regional domain name is returned by API Gateway when you create a regional endpoint.
         */
        public var regionalDomainName: kotlin.String? = null
        /**
         * The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint. For more information, see Set up a Regional Custom Domain Name and AWS Regions and Endpoints for API Gateway.
         */
        public var regionalHostedZoneId: kotlin.String? = null
        /**
         * The Transport Layer Security (TLS) version + cipher suite for this DomainName. The valid values are `TLS_1_0` and `TLS_1_2`.
         */
        public var securityPolicy: aws.sdk.kotlin.services.apigateway.model.SecurityPolicy? = null
        /**
         * The collection of tags. Each tag element is associated with a given resource.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.UpdateDomainNameResponse) : this() {
            this.certificateArn = x.certificateArn
            this.certificateName = x.certificateName
            this.certificateUploadDate = x.certificateUploadDate
            this.distributionDomainName = x.distributionDomainName
            this.distributionHostedZoneId = x.distributionHostedZoneId
            this.domainName = x.domainName
            this.domainNameStatus = x.domainNameStatus
            this.domainNameStatusMessage = x.domainNameStatusMessage
            this.endpointConfiguration = x.endpointConfiguration
            this.mutualTlsAuthentication = x.mutualTlsAuthentication
            this.ownershipVerificationCertificateArn = x.ownershipVerificationCertificateArn
            this.regionalCertificateArn = x.regionalCertificateArn
            this.regionalCertificateName = x.regionalCertificateName
            this.regionalDomainName = x.regionalDomainName
            this.regionalHostedZoneId = x.regionalHostedZoneId
            this.securityPolicy = x.securityPolicy
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.UpdateDomainNameResponse = UpdateDomainNameResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.EndpointConfiguration] inside the given [block]
         */
        public fun endpointConfiguration(block: aws.sdk.kotlin.services.apigateway.model.EndpointConfiguration.Builder.() -> kotlin.Unit) {
            this.endpointConfiguration = aws.sdk.kotlin.services.apigateway.model.EndpointConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.MutualTlsAuthentication] inside the given [block]
         */
        public fun mutualTlsAuthentication(block: aws.sdk.kotlin.services.apigateway.model.MutualTlsAuthentication.Builder.() -> kotlin.Unit) {
            this.mutualTlsAuthentication = aws.sdk.kotlin.services.apigateway.model.MutualTlsAuthentication.invoke(block)
        }
    }
}
