// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.transform

import aws.sdk.kotlin.services.apigateway.model.CreateDocumentationPartRequest
import aws.sdk.kotlin.services.apigateway.model.DocumentationPartLocation
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateDocumentationPartOperationSerializer: HttpSerialize<CreateDocumentationPartRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateDocumentationPartRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "restapis",
                "${input.restApiId}".encodeLabel(),
                "documentation",
                "parts",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateDocumentationPartOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateDocumentationPartOperationBody(context: ExecutionContext, input: CreateDocumentationPartRequest): ByteArray {
    val serializer = JsonSerializer()
    val LOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("location"))
    val PROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("properties"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LOCATION_DESCRIPTOR)
        field(PROPERTIES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.location?.let { field(LOCATION_DESCRIPTOR, it, ::serializeDocumentationPartLocationDocument) }
        input.properties?.let { field(PROPERTIES_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
