// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * A request to create a new domain name.
 */
public class CreateDomainNameRequest private constructor(builder: Builder) {
    /**
     * The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.
     */
    public val certificateArn: kotlin.String? = builder.certificateArn
    /**
     * &#91;Deprecated&#93; The body of the server certificate that will be used by edge-optimized endpoint for this domain name provided by your certificate authority.
     */
    public val certificateBody: kotlin.String? = builder.certificateBody
    /**
     * &#91;Deprecated&#93; The intermediate certificates and optionally the root certificate, one after the other without any blank lines, used by an edge-optimized endpoint for this domain name. If you include the root certificate, your certificate chain must start with intermediate certificates and end with the root certificate. Use the intermediate certificates that were provided by your certificate authority. Do not include any intermediaries that are not in the chain of trust path.
     */
    public val certificateChain: kotlin.String? = builder.certificateChain
    /**
     * The user-friendly name of the certificate that will be used by edge-optimized endpoint for this domain name.
     */
    public val certificateName: kotlin.String? = builder.certificateName
    /**
     * &#91;Deprecated&#93; Your edge-optimized endpoint's domain name certificate's private key.
     */
    public val certificatePrivateKey: kotlin.String? = builder.certificatePrivateKey
    /**
     * The name of the DomainName resource.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * The endpoint configuration of this DomainName showing the endpoint types of the domain name.
     */
    public val endpointConfiguration: aws.sdk.kotlin.services.apigateway.model.EndpointConfiguration? = builder.endpointConfiguration
    /**
     * The mutual TLS authentication configuration for a custom domain name. If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your API.
     */
    public val mutualTlsAuthentication: aws.sdk.kotlin.services.apigateway.model.MutualTlsAuthenticationInput? = builder.mutualTlsAuthentication
    /**
     * The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn.
     */
    public val ownershipVerificationCertificateArn: kotlin.String? = builder.ownershipVerificationCertificateArn
    /**
     * The reference to an AWS-managed certificate that will be used by regional endpoint for this domain name. AWS Certificate Manager is the only supported source.
     */
    public val regionalCertificateArn: kotlin.String? = builder.regionalCertificateArn
    /**
     * The user-friendly name of the certificate that will be used by regional endpoint for this domain name.
     */
    public val regionalCertificateName: kotlin.String? = builder.regionalCertificateName
    /**
     * The Transport Layer Security (TLS) version + cipher suite for this DomainName. The valid values are `TLS_1_0` and `TLS_1_2`.
     */
    public val securityPolicy: aws.sdk.kotlin.services.apigateway.model.SecurityPolicy? = builder.securityPolicy
    /**
     * The key-value map of strings. The valid character set is &#91;a-zA-Z+-=._:/&#93;. The tag key can be up to 128 characters and must not start with `aws:`. The tag value can be up to 256 characters.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.CreateDomainNameRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDomainNameRequest(")
        append("certificateArn=$certificateArn,")
        append("certificateBody=$certificateBody,")
        append("certificateChain=$certificateChain,")
        append("certificateName=$certificateName,")
        append("certificatePrivateKey=$certificatePrivateKey,")
        append("domainName=$domainName,")
        append("endpointConfiguration=$endpointConfiguration,")
        append("mutualTlsAuthentication=$mutualTlsAuthentication,")
        append("ownershipVerificationCertificateArn=$ownershipVerificationCertificateArn,")
        append("regionalCertificateArn=$regionalCertificateArn,")
        append("regionalCertificateName=$regionalCertificateName,")
        append("securityPolicy=$securityPolicy,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateArn?.hashCode() ?: 0
        result = 31 * result + (certificateBody?.hashCode() ?: 0)
        result = 31 * result + (certificateChain?.hashCode() ?: 0)
        result = 31 * result + (certificateName?.hashCode() ?: 0)
        result = 31 * result + (certificatePrivateKey?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (endpointConfiguration?.hashCode() ?: 0)
        result = 31 * result + (mutualTlsAuthentication?.hashCode() ?: 0)
        result = 31 * result + (ownershipVerificationCertificateArn?.hashCode() ?: 0)
        result = 31 * result + (regionalCertificateArn?.hashCode() ?: 0)
        result = 31 * result + (regionalCertificateName?.hashCode() ?: 0)
        result = 31 * result + (securityPolicy?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDomainNameRequest

        if (certificateArn != other.certificateArn) return false
        if (certificateBody != other.certificateBody) return false
        if (certificateChain != other.certificateChain) return false
        if (certificateName != other.certificateName) return false
        if (certificatePrivateKey != other.certificatePrivateKey) return false
        if (domainName != other.domainName) return false
        if (endpointConfiguration != other.endpointConfiguration) return false
        if (mutualTlsAuthentication != other.mutualTlsAuthentication) return false
        if (ownershipVerificationCertificateArn != other.ownershipVerificationCertificateArn) return false
        if (regionalCertificateArn != other.regionalCertificateArn) return false
        if (regionalCertificateName != other.regionalCertificateName) return false
        if (securityPolicy != other.securityPolicy) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.CreateDomainNameRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.
         */
        public var certificateArn: kotlin.String? = null
        /**
         * &#91;Deprecated&#93; The body of the server certificate that will be used by edge-optimized endpoint for this domain name provided by your certificate authority.
         */
        public var certificateBody: kotlin.String? = null
        /**
         * &#91;Deprecated&#93; The intermediate certificates and optionally the root certificate, one after the other without any blank lines, used by an edge-optimized endpoint for this domain name. If you include the root certificate, your certificate chain must start with intermediate certificates and end with the root certificate. Use the intermediate certificates that were provided by your certificate authority. Do not include any intermediaries that are not in the chain of trust path.
         */
        public var certificateChain: kotlin.String? = null
        /**
         * The user-friendly name of the certificate that will be used by edge-optimized endpoint for this domain name.
         */
        public var certificateName: kotlin.String? = null
        /**
         * &#91;Deprecated&#93; Your edge-optimized endpoint's domain name certificate's private key.
         */
        public var certificatePrivateKey: kotlin.String? = null
        /**
         * The name of the DomainName resource.
         */
        public var domainName: kotlin.String? = null
        /**
         * The endpoint configuration of this DomainName showing the endpoint types of the domain name.
         */
        public var endpointConfiguration: aws.sdk.kotlin.services.apigateway.model.EndpointConfiguration? = null
        /**
         * The mutual TLS authentication configuration for a custom domain name. If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your API.
         */
        public var mutualTlsAuthentication: aws.sdk.kotlin.services.apigateway.model.MutualTlsAuthenticationInput? = null
        /**
         * The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn.
         */
        public var ownershipVerificationCertificateArn: kotlin.String? = null
        /**
         * The reference to an AWS-managed certificate that will be used by regional endpoint for this domain name. AWS Certificate Manager is the only supported source.
         */
        public var regionalCertificateArn: kotlin.String? = null
        /**
         * The user-friendly name of the certificate that will be used by regional endpoint for this domain name.
         */
        public var regionalCertificateName: kotlin.String? = null
        /**
         * The Transport Layer Security (TLS) version + cipher suite for this DomainName. The valid values are `TLS_1_0` and `TLS_1_2`.
         */
        public var securityPolicy: aws.sdk.kotlin.services.apigateway.model.SecurityPolicy? = null
        /**
         * The key-value map of strings. The valid character set is &#91;a-zA-Z+-=._:/&#93;. The tag key can be up to 128 characters and must not start with `aws:`. The tag value can be up to 256 characters.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.CreateDomainNameRequest) : this() {
            this.certificateArn = x.certificateArn
            this.certificateBody = x.certificateBody
            this.certificateChain = x.certificateChain
            this.certificateName = x.certificateName
            this.certificatePrivateKey = x.certificatePrivateKey
            this.domainName = x.domainName
            this.endpointConfiguration = x.endpointConfiguration
            this.mutualTlsAuthentication = x.mutualTlsAuthentication
            this.ownershipVerificationCertificateArn = x.ownershipVerificationCertificateArn
            this.regionalCertificateArn = x.regionalCertificateArn
            this.regionalCertificateName = x.regionalCertificateName
            this.securityPolicy = x.securityPolicy
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.CreateDomainNameRequest = CreateDomainNameRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.EndpointConfiguration] inside the given [block]
         */
        public fun endpointConfiguration(block: aws.sdk.kotlin.services.apigateway.model.EndpointConfiguration.Builder.() -> kotlin.Unit) {
            this.endpointConfiguration = aws.sdk.kotlin.services.apigateway.model.EndpointConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.MutualTlsAuthenticationInput] inside the given [block]
         */
        public fun mutualTlsAuthentication(block: aws.sdk.kotlin.services.apigateway.model.MutualTlsAuthenticationInput.Builder.() -> kotlin.Unit) {
            this.mutualTlsAuthentication = aws.sdk.kotlin.services.apigateway.model.MutualTlsAuthenticationInput.invoke(block)
        }
    }
}
