// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * The GET request to get the usage data of a usage plan in a specified time interval.
 */
public class GetUsageRequest private constructor(builder: Builder) {
    /**
     * The ending date (e.g., 2016-12-31) of the usage data.
     */
    public val endDate: kotlin.String? = requireNotNull(builder.endDate) { "A non-null value must be provided for endDate" }
    /**
     * The Id of the API key associated with the resultant usage data.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
     */
    public val limit: kotlin.Int? = builder.limit
    /**
     * The current pagination position in the paged result set.
     */
    public val position: kotlin.String? = builder.position
    /**
     * The starting date (e.g., 2016-01-01) of the usage data.
     */
    public val startDate: kotlin.String? = requireNotNull(builder.startDate) { "A non-null value must be provided for startDate" }
    /**
     * The Id of the usage plan associated with the usage data.
     */
    public val usagePlanId: kotlin.String? = requireNotNull(builder.usagePlanId) { "A non-null value must be provided for usagePlanId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.GetUsageRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetUsageRequest(")
        append("endDate=$endDate,")
        append("keyId=$keyId,")
        append("limit=$limit,")
        append("position=$position,")
        append("startDate=$startDate,")
        append("usagePlanId=$usagePlanId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endDate?.hashCode() ?: 0
        result = 31 * result + (keyId?.hashCode() ?: 0)
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (position?.hashCode() ?: 0)
        result = 31 * result + (startDate?.hashCode() ?: 0)
        result = 31 * result + (usagePlanId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetUsageRequest

        if (endDate != other.endDate) return false
        if (keyId != other.keyId) return false
        if (limit != other.limit) return false
        if (position != other.position) return false
        if (startDate != other.startDate) return false
        if (usagePlanId != other.usagePlanId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.GetUsageRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ending date (e.g., 2016-12-31) of the usage data.
         */
        public var endDate: kotlin.String? = null
        /**
         * The Id of the API key associated with the resultant usage data.
         */
        public var keyId: kotlin.String? = null
        /**
         * The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
         */
        public var limit: kotlin.Int? = null
        /**
         * The current pagination position in the paged result set.
         */
        public var position: kotlin.String? = null
        /**
         * The starting date (e.g., 2016-01-01) of the usage data.
         */
        public var startDate: kotlin.String? = null
        /**
         * The Id of the usage plan associated with the usage data.
         */
        public var usagePlanId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.GetUsageRequest) : this() {
            this.endDate = x.endDate
            this.keyId = x.keyId
            this.limit = x.limit
            this.position = x.position
            this.startDate = x.startDate
            this.usagePlanId = x.usagePlanId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.GetUsageRequest = GetUsageRequest(this)
    }
}
