// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Make a request to simulate the invocation of a Method.
 */
public class TestInvokeMethodRequest private constructor(builder: Builder) {
    /**
     * The simulated request body of an incoming invocation request.
     */
    public val body: kotlin.String? = builder.body
    /**
     * A ClientCertificate identifier to use in the test invocation. API Gateway will use the certificate when making the HTTPS request to the defined back-end endpoint.
     */
    public val clientCertificateId: kotlin.String? = builder.clientCertificateId
    /**
     * A key-value map of headers to simulate an incoming invocation request.
     */
    public val headers: Map<String, String>? = builder.headers
    /**
     * Specifies a test invoke method request's HTTP method.
     */
    public val httpMethod: kotlin.String? = requireNotNull(builder.httpMethod) { "A non-null value must be provided for httpMethod" }
    /**
     * The headers as a map from string to list of values to simulate an incoming invocation request.
     */
    public val multiValueHeaders: Map<String, List<String>>? = builder.multiValueHeaders
    /**
     * The URI path, including query string, of the simulated invocation request. Use this to specify path parameters and query string parameters.
     */
    public val pathWithQueryString: kotlin.String? = builder.pathWithQueryString
    /**
     * Specifies a test invoke method request's resource ID.
     */
    public val resourceId: kotlin.String? = requireNotNull(builder.resourceId) { "A non-null value must be provided for resourceId" }
    /**
     * The string identifier of the associated RestApi.
     */
    public val restApiId: kotlin.String? = requireNotNull(builder.restApiId) { "A non-null value must be provided for restApiId" }
    /**
     * A key-value map of stage variables to simulate an invocation on a deployed Stage.
     */
    public val stageVariables: Map<String, String>? = builder.stageVariables

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.TestInvokeMethodRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TestInvokeMethodRequest(")
        append("body=$body,")
        append("clientCertificateId=$clientCertificateId,")
        append("headers=$headers,")
        append("httpMethod=$httpMethod,")
        append("multiValueHeaders=$multiValueHeaders,")
        append("pathWithQueryString=$pathWithQueryString,")
        append("resourceId=$resourceId,")
        append("restApiId=$restApiId,")
        append("stageVariables=$stageVariables")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = body?.hashCode() ?: 0
        result = 31 * result + (clientCertificateId?.hashCode() ?: 0)
        result = 31 * result + (headers?.hashCode() ?: 0)
        result = 31 * result + (httpMethod?.hashCode() ?: 0)
        result = 31 * result + (multiValueHeaders?.hashCode() ?: 0)
        result = 31 * result + (pathWithQueryString?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        result = 31 * result + (stageVariables?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TestInvokeMethodRequest

        if (body != other.body) return false
        if (clientCertificateId != other.clientCertificateId) return false
        if (headers != other.headers) return false
        if (httpMethod != other.httpMethod) return false
        if (multiValueHeaders != other.multiValueHeaders) return false
        if (pathWithQueryString != other.pathWithQueryString) return false
        if (resourceId != other.resourceId) return false
        if (restApiId != other.restApiId) return false
        if (stageVariables != other.stageVariables) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.TestInvokeMethodRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The simulated request body of an incoming invocation request.
         */
        public var body: kotlin.String? = null
        /**
         * A ClientCertificate identifier to use in the test invocation. API Gateway will use the certificate when making the HTTPS request to the defined back-end endpoint.
         */
        public var clientCertificateId: kotlin.String? = null
        /**
         * A key-value map of headers to simulate an incoming invocation request.
         */
        public var headers: Map<String, String>? = null
        /**
         * Specifies a test invoke method request's HTTP method.
         */
        public var httpMethod: kotlin.String? = null
        /**
         * The headers as a map from string to list of values to simulate an incoming invocation request.
         */
        public var multiValueHeaders: Map<String, List<String>>? = null
        /**
         * The URI path, including query string, of the simulated invocation request. Use this to specify path parameters and query string parameters.
         */
        public var pathWithQueryString: kotlin.String? = null
        /**
         * Specifies a test invoke method request's resource ID.
         */
        public var resourceId: kotlin.String? = null
        /**
         * The string identifier of the associated RestApi.
         */
        public var restApiId: kotlin.String? = null
        /**
         * A key-value map of stage variables to simulate an invocation on a deployed Stage.
         */
        public var stageVariables: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.TestInvokeMethodRequest) : this() {
            this.body = x.body
            this.clientCertificateId = x.clientCertificateId
            this.headers = x.headers
            this.httpMethod = x.httpMethod
            this.multiValueHeaders = x.multiValueHeaders
            this.pathWithQueryString = x.pathWithQueryString
            this.resourceId = x.resourceId
            this.restApiId = x.restApiId
            this.stageVariables = x.stageVariables
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.TestInvokeMethodRequest = TestInvokeMethodRequest(this)
    }
}
