// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.apigateway.model.ApiGatewayException
import aws.sdk.kotlin.services.apigateway.model.GetAccountResponse
import aws.sdk.kotlin.services.apigateway.model.ThrottleSettings
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetAccountOperationDeserializer: HttpDeserialize<GetAccountResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetAccountResponse {
        if (!response.status.isSuccess()) {
            throwGetAccountError(context, response)
        }
        val builder = GetAccountResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetAccountOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetAccountError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ApiGatewayException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ApiGatewayException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetAccountOperationBody(builder: GetAccountResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APIKEYVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("apiKeyVersion"))
    val CLOUDWATCHROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("cloudwatchRoleArn"))
    val FEATURES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("features"))
    val THROTTLESETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("throttleSettings"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APIKEYVERSION_DESCRIPTOR)
        field(CLOUDWATCHROLEARN_DESCRIPTOR)
        field(FEATURES_DESCRIPTOR)
        field(THROTTLESETTINGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APIKEYVERSION_DESCRIPTOR.index -> builder.apiKeyVersion = deserializeString()
                CLOUDWATCHROLEARN_DESCRIPTOR.index -> builder.cloudwatchRoleArn = deserializeString()
                FEATURES_DESCRIPTOR.index -> builder.features =
                    deserializer.deserializeList(FEATURES_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                THROTTLESETTINGS_DESCRIPTOR.index -> builder.throttleSettings = deserializeThrottleSettingsDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
