// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.apigateway.model.ApiGatewayException
import aws.sdk.kotlin.services.apigateway.model.ContentHandlingStrategy
import aws.sdk.kotlin.services.apigateway.model.GetIntegrationResponseResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableMapOf


internal class GetIntegrationResponseOperationDeserializer: HttpDeserialize<GetIntegrationResponseResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetIntegrationResponseResponse {
        if (!response.status.isSuccess()) {
            throwGetIntegrationResponseError(context, response)
        }
        val builder = GetIntegrationResponseResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetIntegrationResponseOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetIntegrationResponseError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ApiGatewayException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ApiGatewayException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetIntegrationResponseOperationBody(builder: GetIntegrationResponseResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONTENTHANDLING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("contentHandling"))
    val RESPONSEPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("responseParameters"))
    val RESPONSETEMPLATES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("responseTemplates"))
    val SELECTIONPATTERN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("selectionPattern"))
    val STATUSCODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("statusCode"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONTENTHANDLING_DESCRIPTOR)
        field(RESPONSEPARAMETERS_DESCRIPTOR)
        field(RESPONSETEMPLATES_DESCRIPTOR)
        field(SELECTIONPATTERN_DESCRIPTOR)
        field(STATUSCODE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONTENTHANDLING_DESCRIPTOR.index -> builder.contentHandling = deserializeString().let { ContentHandlingStrategy.fromValue(it) }
                RESPONSEPARAMETERS_DESCRIPTOR.index -> builder.responseParameters =
                    deserializer.deserializeMap(RESPONSEPARAMETERS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                RESPONSETEMPLATES_DESCRIPTOR.index -> builder.responseTemplates =
                    deserializer.deserializeMap(RESPONSETEMPLATES_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                SELECTIONPATTERN_DESCRIPTOR.index -> builder.selectionPattern = deserializeString()
                STATUSCODE_DESCRIPTOR.index -> builder.statusCode = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
