// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Configuration settings of a canary deployment.
 */
class CanarySettings private constructor(builder: Builder) {
    /**
     * The ID of the canary deployment.
     */
    val deploymentId: kotlin.String? = builder.deploymentId
    /**
     * The percent (0-100) of traffic diverted to a canary deployment.
     */
    val percentTraffic: kotlin.Double = builder.percentTraffic
    /**
     * Stage variables overridden for a canary release deployment, including new stage variables introduced in the canary. These stage variables are represented as a string-to-string map between stage variable names and their values.
     */
    val stageVariableOverrides: Map<String, String>? = builder.stageVariableOverrides
    /**
     * A Boolean flag to indicate whether the canary deployment uses the stage cache or not.
     */
    val useStageCache: kotlin.Boolean = builder.useStageCache

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.CanarySettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CanarySettings(")
        append("deploymentId=$deploymentId,")
        append("percentTraffic=$percentTraffic,")
        append("stageVariableOverrides=$stageVariableOverrides,")
        append("useStageCache=$useStageCache)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deploymentId?.hashCode() ?: 0
        result = 31 * result + (percentTraffic.hashCode())
        result = 31 * result + (stageVariableOverrides?.hashCode() ?: 0)
        result = 31 * result + (useStageCache.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CanarySettings

        if (deploymentId != other.deploymentId) return false
        if (percentTraffic != other.percentTraffic) return false
        if (stageVariableOverrides != other.stageVariableOverrides) return false
        if (useStageCache != other.useStageCache) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.CanarySettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID of the canary deployment.
         */
        var deploymentId: kotlin.String? = null
        /**
         * The percent (0-100) of traffic diverted to a canary deployment.
         */
        var percentTraffic: kotlin.Double = 0.0
        /**
         * Stage variables overridden for a canary release deployment, including new stage variables introduced in the canary. These stage variables are represented as a string-to-string map between stage variable names and their values.
         */
        var stageVariableOverrides: Map<String, String>? = null
        /**
         * A Boolean flag to indicate whether the canary deployment uses the stage cache or not.
         */
        var useStageCache: kotlin.Boolean = false

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.CanarySettings) : this() {
            this.deploymentId = x.deploymentId
            this.percentTraffic = x.percentTraffic
            this.stageVariableOverrides = x.stageVariableOverrides
            this.useStageCache = x.useStageCache
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.CanarySettings = CanarySettings(this)
    }
}
