// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * The POST request to create a usage plan with the name, description, throttle limits and quota limits, as well as the associated API stages, specified in the payload.
 */
class CreateUsagePlanRequest private constructor(builder: Builder) {
    /**
     * The associated API stages of the usage plan.
     */
    val apiStages: List<ApiStage>? = builder.apiStages
    /**
     * The description of the usage plan.
     */
    val description: kotlin.String? = builder.description
    /**
     * &#91;Required&#93; The name of the usage plan.
     */
    val name: kotlin.String? = builder.name
    /**
     * The quota of the usage plan.
     */
    val quota: aws.sdk.kotlin.services.apigateway.model.QuotaSettings? = builder.quota
    /**
     * The key-value map of strings. The valid character set is &#91;a-zA-Z+-=._:/&#93;. The tag key can be up to 128 characters and must not start with aws:. The tag value can be up to 256 characters.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The throttling limits of the usage plan.
     */
    val throttle: aws.sdk.kotlin.services.apigateway.model.ThrottleSettings? = builder.throttle

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.CreateUsagePlanRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateUsagePlanRequest(")
        append("apiStages=$apiStages,")
        append("description=$description,")
        append("name=$name,")
        append("quota=$quota,")
        append("tags=$tags,")
        append("throttle=$throttle)")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiStages?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (quota?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (throttle?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateUsagePlanRequest

        if (apiStages != other.apiStages) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (quota != other.quota) return false
        if (tags != other.tags) return false
        if (throttle != other.throttle) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.CreateUsagePlanRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The associated API stages of the usage plan.
         */
        var apiStages: List<ApiStage>? = null
        /**
         * The description of the usage plan.
         */
        var description: kotlin.String? = null
        /**
         * &#91;Required&#93; The name of the usage plan.
         */
        var name: kotlin.String? = null
        /**
         * The quota of the usage plan.
         */
        var quota: aws.sdk.kotlin.services.apigateway.model.QuotaSettings? = null
        /**
         * The key-value map of strings. The valid character set is &#91;a-zA-Z+-=._:/&#93;. The tag key can be up to 128 characters and must not start with aws:. The tag value can be up to 256 characters.
         */
        var tags: Map<String, String>? = null
        /**
         * The throttling limits of the usage plan.
         */
        var throttle: aws.sdk.kotlin.services.apigateway.model.ThrottleSettings? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.CreateUsagePlanRequest) : this() {
            this.apiStages = x.apiStages
            this.description = x.description
            this.name = x.name
            this.quota = x.quota
            this.tags = x.tags
            this.throttle = x.throttle
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.CreateUsagePlanRequest = CreateUsagePlanRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.QuotaSettings] inside the given [block]
         */
        fun quota(block: aws.sdk.kotlin.services.apigateway.model.QuotaSettings.Builder.() -> kotlin.Unit) {
            this.quota = aws.sdk.kotlin.services.apigateway.model.QuotaSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.ThrottleSettings] inside the given [block]
         */
        fun throttle(block: aws.sdk.kotlin.services.apigateway.model.ThrottleSettings.Builder.() -> kotlin.Unit) {
            this.throttle = aws.sdk.kotlin.services.apigateway.model.ThrottleSettings.invoke(block)
        }
    }
}
