// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * The input configuration for a canary deployment.
 */
class DeploymentCanarySettings private constructor(builder: Builder) {
    /**
     * The percentage (0.0-100.0) of traffic routed to the canary deployment.
     */
    val percentTraffic: kotlin.Double = builder.percentTraffic
    /**
     * A stage variable overrides used for the canary release deployment. They can override existing stage variables or add new stage variables for the canary release deployment. These stage variables are represented as a string-to-string map between stage variable names and their values.
     */
    val stageVariableOverrides: Map<String, String>? = builder.stageVariableOverrides
    /**
     * A Boolean flag to indicate whether the canary release deployment uses the stage cache or not.
     */
    val useStageCache: kotlin.Boolean = builder.useStageCache

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.DeploymentCanarySettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeploymentCanarySettings(")
        append("percentTraffic=$percentTraffic,")
        append("stageVariableOverrides=$stageVariableOverrides,")
        append("useStageCache=$useStageCache)")
    }

    override fun hashCode(): kotlin.Int {
        var result = percentTraffic.hashCode()
        result = 31 * result + (stageVariableOverrides?.hashCode() ?: 0)
        result = 31 * result + (useStageCache.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeploymentCanarySettings

        if (percentTraffic != other.percentTraffic) return false
        if (stageVariableOverrides != other.stageVariableOverrides) return false
        if (useStageCache != other.useStageCache) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.DeploymentCanarySettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * The percentage (0.0-100.0) of traffic routed to the canary deployment.
         */
        var percentTraffic: kotlin.Double = 0.0
        /**
         * A stage variable overrides used for the canary release deployment. They can override existing stage variables or add new stage variables for the canary release deployment. These stage variables are represented as a string-to-string map between stage variable names and their values.
         */
        var stageVariableOverrides: Map<String, String>? = null
        /**
         * A Boolean flag to indicate whether the canary release deployment uses the stage cache or not.
         */
        var useStageCache: kotlin.Boolean = false

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.DeploymentCanarySettings) : this() {
            this.percentTraffic = x.percentTraffic
            this.stageVariableOverrides = x.stageVariableOverrides
            this.useStageCache = x.useStageCache
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.DeploymentCanarySettings = DeploymentCanarySettings(this)
    }
}
