// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Requests API Gateway to get information about a Deployment resource.
 */
class GetDeploymentRequest private constructor(builder: Builder) {
    /**
     * &#91;Required&#93; The identifier of the Deployment resource to get information about.
     */
    val deploymentId: kotlin.String? = builder.deploymentId
    /**
     * A query parameter to retrieve the specified embedded resources of the returned Deployment resource in the response. In a REST API call, this embed parameter value is a list of comma-separated strings, as in  GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=var1,var2. The SDK and other platform-dependent libraries might use a different format for the list. Currently, this request supports only retrieval of the embedded API summary this way. Hence, the parameter value must be a single-valued list containing only the "apisummary" string.  For example, GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=apisummary.
     */
    val embed: List<String>? = builder.embed
    /**
     * &#91;Required&#93; The string identifier of the associated RestApi.
     */
    val restApiId: kotlin.String? = builder.restApiId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.GetDeploymentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetDeploymentRequest(")
        append("deploymentId=$deploymentId,")
        append("embed=$embed,")
        append("restApiId=$restApiId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deploymentId?.hashCode() ?: 0
        result = 31 * result + (embed?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetDeploymentRequest

        if (deploymentId != other.deploymentId) return false
        if (embed != other.embed) return false
        if (restApiId != other.restApiId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.GetDeploymentRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * &#91;Required&#93; The identifier of the Deployment resource to get information about.
         */
        var deploymentId: kotlin.String? = null
        /**
         * A query parameter to retrieve the specified embedded resources of the returned Deployment resource in the response. In a REST API call, this embed parameter value is a list of comma-separated strings, as in  GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=var1,var2. The SDK and other platform-dependent libraries might use a different format for the list. Currently, this request supports only retrieval of the embedded API summary this way. Hence, the parameter value must be a single-valued list containing only the "apisummary" string.  For example, GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=apisummary.
         */
        var embed: List<String>? = null
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        var restApiId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.GetDeploymentRequest) : this() {
            this.deploymentId = x.deploymentId
            this.embed = x.embed
            this.restApiId = x.restApiId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.GetDeploymentRequest = GetDeploymentRequest(this)
    }
}
