// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A snapshot of the documentation of an API.
 * <div class="remarks">Publishing API documentation involves creating a documentation version associated with an API stage and exporting the versioned documentation to an external (e.g., OpenAPI) file.</div>
 * <div class="seeAlso">
 * <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-documenting-api.html">Documenting an API, DocumentationPart, DocumentationVersions
 * </div>
 */
class UpdateDocumentationVersionResponse private constructor(builder: Builder) {
    /**
     * The date when the API documentation snapshot is created.
     */
    val createdDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createdDate
    /**
     * The description of the API documentation snapshot.
     */
    val description: kotlin.String? = builder.description
    /**
     * The version identifier of the API documentation snapshot.
     */
    val version: kotlin.String? = builder.version

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.UpdateDocumentationVersionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateDocumentationVersionResponse(")
        append("createdDate=$createdDate,")
        append("description=$description,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdDate?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateDocumentationVersionResponse

        if (createdDate != other.createdDate) return false
        if (description != other.description) return false
        if (version != other.version) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.UpdateDocumentationVersionResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The date when the API documentation snapshot is created.
         */
        var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the API documentation snapshot.
         */
        var description: kotlin.String? = null
        /**
         * The version identifier of the API documentation snapshot.
         */
        var version: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.UpdateDocumentationVersionResponse) : this() {
            this.createdDate = x.createdDate
            this.description = x.description
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.UpdateDocumentationVersionResponse = UpdateDocumentationVersionResponse(this)
    }
}
