// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.transform

import aws.sdk.kotlin.services.apigateway.model.CacheClusterSize
import aws.sdk.kotlin.services.apigateway.model.CreateDeploymentRequest
import aws.sdk.kotlin.services.apigateway.model.DeploymentCanarySettings
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateDeploymentOperationSerializer: HttpSerialize<CreateDeploymentRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateDeploymentRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "restapis",
                "${input.restApiId}".encodeLabel(),
                "deployments",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateDeploymentOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        builder.headers.setMissing("Content-Type", "application/json")
        return builder
    }
}

private fun serializeCreateDeploymentOperationBody(context: ExecutionContext, input: CreateDeploymentRequest): ByteArray {
    val serializer = JsonSerializer()
    val CACHECLUSTERENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("cacheClusterEnabled"))
    val CACHECLUSTERSIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("cacheClusterSize"))
    val CANARYSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("canarySettings"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val STAGEDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("stageDescription"))
    val STAGENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("stageName"))
    val TRACINGENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("tracingEnabled"))
    val VARIABLES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("variables"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CACHECLUSTERENABLED_DESCRIPTOR)
        field(CACHECLUSTERSIZE_DESCRIPTOR)
        field(CANARYSETTINGS_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(STAGEDESCRIPTION_DESCRIPTOR)
        field(STAGENAME_DESCRIPTOR)
        field(TRACINGENABLED_DESCRIPTOR)
        field(VARIABLES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.cacheClusterEnabled?.let { field(CACHECLUSTERENABLED_DESCRIPTOR, it) }
        input.cacheClusterSize?.let { field(CACHECLUSTERSIZE_DESCRIPTOR, it.value) }
        input.canarySettings?.let { field(CANARYSETTINGS_DESCRIPTOR, it, ::serializeDeploymentCanarySettingsDocument) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.stageDescription?.let { field(STAGEDESCRIPTION_DESCRIPTOR, it) }
        input.stageName?.let { field(STAGENAME_DESCRIPTOR, it) }
        input.tracingEnabled?.let { field(TRACINGENABLED_DESCRIPTOR, it) }
        if (input.variables != null) {
            mapField(VARIABLES_DESCRIPTOR) {
                input.variables.forEach { (key, value) -> entry(key, value) }
            }
        }
    }
    return serializer.toByteArray()
}
