// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.transform

import aws.sdk.kotlin.services.apigateway.model.ContentHandlingStrategy
import aws.sdk.kotlin.services.apigateway.model.PutIntegrationResponseRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutIntegrationResponseOperationSerializer: HttpSerialize<PutIntegrationResponseRequest> {
    override suspend fun serialize(context: ExecutionContext, input: PutIntegrationResponseRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf(
                "restapis",
                "${input.restApiId}".encodeLabel(),
                "resources",
                "${input.resourceId}".encodeLabel(),
                "methods",
                "${input.httpMethod}".encodeLabel(),
                "integration",
                "responses",
                "${input.statusCode}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializePutIntegrationResponseOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        builder.headers.setMissing("Content-Type", "application/json")
        return builder
    }
}

private fun serializePutIntegrationResponseOperationBody(context: ExecutionContext, input: PutIntegrationResponseRequest): ByteArray {
    val serializer = JsonSerializer()
    val CONTENTHANDLING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("contentHandling"))
    val RESPONSEPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("responseParameters"))
    val RESPONSETEMPLATES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("responseTemplates"))
    val SELECTIONPATTERN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("selectionPattern"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONTENTHANDLING_DESCRIPTOR)
        field(RESPONSEPARAMETERS_DESCRIPTOR)
        field(RESPONSETEMPLATES_DESCRIPTOR)
        field(SELECTIONPATTERN_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.contentHandling?.let { field(CONTENTHANDLING_DESCRIPTOR, it.value) }
        if (input.responseParameters != null) {
            mapField(RESPONSEPARAMETERS_DESCRIPTOR) {
                input.responseParameters.forEach { (key, value) -> entry(key, value) }
            }
        }
        if (input.responseTemplates != null) {
            mapField(RESPONSETEMPLATES_DESCRIPTOR) {
                input.responseTemplates.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.selectionPattern?.let { field(SELECTIONPATTERN_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
