// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Access log settings, including the access log format and access log destination ARN.
 */
class AccessLogSettings private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to receive access logs. If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with amazon-apigateway-.
     */
    val destinationArn: kotlin.String? = builder.destinationArn
    /**
     * A single line format of the access logs of data, as specified by selected <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#context-variable-reference">$context variables. The format must include at least $context.requestId.
     */
    val format: kotlin.String? = builder.format

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.AccessLogSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccessLogSettings(")
        append("destinationArn=$destinationArn,")
        append("format=$format)")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationArn?.hashCode() ?: 0
        result = 31 * result + (format?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccessLogSettings

        if (destinationArn != other.destinationArn) return false
        if (format != other.format) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.AccessLogSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to receive access logs. If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with amazon-apigateway-.
         */
        var destinationArn: kotlin.String? = null
        /**
         * A single line format of the access logs of data, as specified by selected <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#context-variable-reference">$context variables. The format must include at least $context.requestId.
         */
        var format: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.AccessLogSettings) : this() {
            this.destinationArn = x.destinationArn
            this.format = x.format
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.AccessLogSettings = AccessLogSettings(this)
    }
}
