// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Request to create an ApiKey resource.
 */
class CreateApiKeyRequest private constructor(builder: Builder) {
    /**
     * An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.
     */
    val customerId: kotlin.String? = builder.customerId
    /**
     * The description of the ApiKey.
     */
    val description: kotlin.String? = builder.description
    /**
     * Specifies whether the ApiKey can be used by callers.
     */
    val enabled: kotlin.Boolean = builder.enabled
    /**
     * Specifies whether (true) or not (false) the key identifier is distinct from the created API key value. This parameter is deprecated and should not be used.
     */
    val generateDistinctId: kotlin.Boolean = builder.generateDistinctId
    /**
     * The name of the ApiKey.
     */
    val name: kotlin.String? = builder.name
    /**
     * DEPRECATED FOR USAGE PLANS - Specifies stages associated with the API key.
     */
    val stageKeys: List<StageKey>? = builder.stageKeys
    /**
     * The key-value map of strings. The valid character set is &#91;a-zA-Z+-=._:/&#93;. The tag key can be up to 128 characters and must not start with aws:. The tag value can be up to 256 characters.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * Specifies a value of the API key. <!-- Why is this declared as the input to create an API key? As a form of copying an existing key value into a new API key? -->
     */
    val value: kotlin.String? = builder.value

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.CreateApiKeyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateApiKeyRequest(")
        append("customerId=$customerId,")
        append("description=$description,")
        append("enabled=$enabled,")
        append("generateDistinctId=$generateDistinctId,")
        append("name=$name,")
        append("stageKeys=$stageKeys,")
        append("tags=$tags,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = customerId?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (enabled.hashCode())
        result = 31 * result + (generateDistinctId.hashCode())
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (stageKeys?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateApiKeyRequest

        if (customerId != other.customerId) return false
        if (description != other.description) return false
        if (enabled != other.enabled) return false
        if (generateDistinctId != other.generateDistinctId) return false
        if (name != other.name) return false
        if (stageKeys != other.stageKeys) return false
        if (tags != other.tags) return false
        if (value != other.value) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.CreateApiKeyRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.
         */
        var customerId: kotlin.String? = null
        /**
         * The description of the ApiKey.
         */
        var description: kotlin.String? = null
        /**
         * Specifies whether the ApiKey can be used by callers.
         */
        var enabled: kotlin.Boolean = false
        /**
         * Specifies whether (true) or not (false) the key identifier is distinct from the created API key value. This parameter is deprecated and should not be used.
         */
        var generateDistinctId: kotlin.Boolean = false
        /**
         * The name of the ApiKey.
         */
        var name: kotlin.String? = null
        /**
         * DEPRECATED FOR USAGE PLANS - Specifies stages associated with the API key.
         */
        var stageKeys: List<StageKey>? = null
        /**
         * The key-value map of strings. The valid character set is &#91;a-zA-Z+-=._:/&#93;. The tag key can be up to 128 characters and must not start with aws:. The tag value can be up to 256 characters.
         */
        var tags: Map<String, String>? = null
        /**
         * Specifies a value of the API key. <!-- Why is this declared as the input to create an API key? As a form of copying an existing key value into a new API key? -->
         */
        var value: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.CreateApiKeyRequest) : this() {
            this.customerId = x.customerId
            this.description = x.description
            this.enabled = x.enabled
            this.generateDistinctId = x.generateDistinctId
            this.name = x.name
            this.stageKeys = x.stageKeys
            this.tags = x.tags
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.CreateApiKeyRequest = CreateApiKeyRequest(this)
    }
}
