// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Requests API Gateway to create a Deployment resource.
 */
class CreateDeploymentRequest private constructor(builder: Builder) {
    /**
     * Enables a cache cluster for the Stage resource specified in the input.
     */
    val cacheClusterEnabled: kotlin.Boolean? = builder.cacheClusterEnabled
    /**
     * Specifies the cache cluster size for the Stage resource specified in the input, if a cache cluster is enabled.
     */
    val cacheClusterSize: aws.sdk.kotlin.services.apigateway.model.CacheClusterSize? = builder.cacheClusterSize
    /**
     * The input configuration for the canary deployment when the deployment is a canary release deployment.
     */
    val canarySettings: aws.sdk.kotlin.services.apigateway.model.DeploymentCanarySettings? = builder.canarySettings
    /**
     * The description for the Deployment resource to create.
     */
    val description: kotlin.String? = builder.description
    /**
     * &#91;Required&#93; The string identifier of the associated RestApi.
     */
    val restApiId: kotlin.String? = builder.restApiId
    /**
     * The description of the Stage resource for the Deployment resource to create.
     */
    val stageDescription: kotlin.String? = builder.stageDescription
    /**
     * The name of the Stage resource for the Deployment resource to create.
     */
    val stageName: kotlin.String? = builder.stageName
    /**
     * Specifies whether active tracing with X-ray is enabled for the Stage.
     */
    val tracingEnabled: kotlin.Boolean? = builder.tracingEnabled
    /**
     * A map that defines the stage variables for the Stage resource that is associated
     * with the new deployment. Variable names can have alphanumeric and underscore characters, and the values
     * must match &#91;A-Za-z0-9-._~:/?#&=,&#93;+.
     */
    val variables: Map<String, String>? = builder.variables

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.CreateDeploymentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDeploymentRequest(")
        append("cacheClusterEnabled=$cacheClusterEnabled,")
        append("cacheClusterSize=$cacheClusterSize,")
        append("canarySettings=$canarySettings,")
        append("description=$description,")
        append("restApiId=$restApiId,")
        append("stageDescription=$stageDescription,")
        append("stageName=$stageName,")
        append("tracingEnabled=$tracingEnabled,")
        append("variables=$variables)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cacheClusterEnabled?.hashCode() ?: 0
        result = 31 * result + (cacheClusterSize?.hashCode() ?: 0)
        result = 31 * result + (canarySettings?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        result = 31 * result + (stageDescription?.hashCode() ?: 0)
        result = 31 * result + (stageName?.hashCode() ?: 0)
        result = 31 * result + (tracingEnabled?.hashCode() ?: 0)
        result = 31 * result + (variables?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDeploymentRequest

        if (cacheClusterEnabled != other.cacheClusterEnabled) return false
        if (cacheClusterSize != other.cacheClusterSize) return false
        if (canarySettings != other.canarySettings) return false
        if (description != other.description) return false
        if (restApiId != other.restApiId) return false
        if (stageDescription != other.stageDescription) return false
        if (stageName != other.stageName) return false
        if (tracingEnabled != other.tracingEnabled) return false
        if (variables != other.variables) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.CreateDeploymentRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Enables a cache cluster for the Stage resource specified in the input.
         */
        var cacheClusterEnabled: kotlin.Boolean? = null
        /**
         * Specifies the cache cluster size for the Stage resource specified in the input, if a cache cluster is enabled.
         */
        var cacheClusterSize: aws.sdk.kotlin.services.apigateway.model.CacheClusterSize? = null
        /**
         * The input configuration for the canary deployment when the deployment is a canary release deployment.
         */
        var canarySettings: aws.sdk.kotlin.services.apigateway.model.DeploymentCanarySettings? = null
        /**
         * The description for the Deployment resource to create.
         */
        var description: kotlin.String? = null
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        var restApiId: kotlin.String? = null
        /**
         * The description of the Stage resource for the Deployment resource to create.
         */
        var stageDescription: kotlin.String? = null
        /**
         * The name of the Stage resource for the Deployment resource to create.
         */
        var stageName: kotlin.String? = null
        /**
         * Specifies whether active tracing with X-ray is enabled for the Stage.
         */
        var tracingEnabled: kotlin.Boolean? = null
        /**
         * A map that defines the stage variables for the Stage resource that is associated
         * with the new deployment. Variable names can have alphanumeric and underscore characters, and the values
         * must match &#91;A-Za-z0-9-._~:/?#&=,&#93;+.
         */
        var variables: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.CreateDeploymentRequest) : this() {
            this.cacheClusterEnabled = x.cacheClusterEnabled
            this.cacheClusterSize = x.cacheClusterSize
            this.canarySettings = x.canarySettings
            this.description = x.description
            this.restApiId = x.restApiId
            this.stageDescription = x.stageDescription
            this.stageName = x.stageName
            this.tracingEnabled = x.tracingEnabled
            this.variables = x.variables
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.CreateDeploymentRequest = CreateDeploymentRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.DeploymentCanarySettings] inside the given [block]
         */
        fun canarySettings(block: aws.sdk.kotlin.services.apigateway.model.DeploymentCanarySettings.Builder.() -> kotlin.Unit) {
            this.canarySettings = aws.sdk.kotlin.services.apigateway.model.DeploymentCanarySettings.invoke(block)
        }
    }
}
