// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * The endpoint configuration to indicate the types of endpoints an API (RestApi) or its custom domain name (DomainName) has.
 */
class EndpointConfiguration private constructor(builder: Builder) {
    /**
     * A list of endpoint types of an API (RestApi) or its custom domain name (DomainName). For an edge-optimized API and its custom domain name, the endpoint type is "EDGE". For a regional API and its custom domain name, the endpoint type is REGIONAL. For a private API, the endpoint type is PRIVATE.
     */
    val types: List<EndpointType>? = builder.types
    /**
     * A list of VpcEndpointIds of an API (RestApi) against which to create Route53 ALIASes. It is only supported for PRIVATE endpoint type.
     */
    val vpcEndpointIds: List<String>? = builder.vpcEndpointIds

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.EndpointConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EndpointConfiguration(")
        append("types=$types,")
        append("vpcEndpointIds=$vpcEndpointIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = types?.hashCode() ?: 0
        result = 31 * result + (vpcEndpointIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EndpointConfiguration

        if (types != other.types) return false
        if (vpcEndpointIds != other.vpcEndpointIds) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.EndpointConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of endpoint types of an API (RestApi) or its custom domain name (DomainName). For an edge-optimized API and its custom domain name, the endpoint type is "EDGE". For a regional API and its custom domain name, the endpoint type is REGIONAL. For a private API, the endpoint type is PRIVATE.
         */
        var types: List<EndpointType>? = null
        /**
         * A list of VpcEndpointIds of an API (RestApi) against which to create Route53 ALIASes. It is only supported for PRIVATE endpoint type.
         */
        var vpcEndpointIds: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.EndpointConfiguration) : this() {
            this.types = x.types
            this.vpcEndpointIds = x.vpcEndpointIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.EndpointConfiguration = EndpointConfiguration(this)
    }
}
