// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Represents an API resource.
 * <div class="seeAlso">
 * <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Create an API
 * </div>
 */
class GetResourceResponse private constructor(builder: Builder) {
    /**
     * The resource's identifier.
     */
    val id: kotlin.String? = builder.id
    /**
     * The parent resource's identifier.
     */
    val parentId: kotlin.String? = builder.parentId
    /**
     * The full path for this resource.
     */
    val path: kotlin.String? = builder.path
    /**
     * The last path segment for this resource.
     */
    val pathPart: kotlin.String? = builder.pathPart
    /**
     * Gets an API resource's method of a given HTTP verb.
     * <div class="remarks">
     * The resource methods are a map of methods indexed by methods' HTTP verbs enabled on the resource. This method map is included in the 200 OK response of the GET /restapis/{restapi_id}/resources/{resource_id} or GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods request.
     * <h4>Example: Get the GET method of an API resource</h4>
     * <h5>Request</h5>
     * <pre>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET HTTP/1.1
     * Content-Type: application/json
     * Host: apigateway.us-east-1.amazonaws.com
     * X-Amz-Date: 20170223T031827Z
     * Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20170223/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</pre>
     * <h5>Response</h5>
     * <pre>{
     * "_links": {
     * "curies": &#91;
     * {
     * "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
     * "name": "integration",
     * "templated": true
     * },
     * {
     * "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
     * "name": "integrationresponse",
     * "templated": true
     * },
     * {
     * "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-{rel}.html",
     * "name": "method",
     * "templated": true
     * },
     * {
     * "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
     * "name": "methodresponse",
     * "templated": true
     * }
     * &#93;,
     * "self": {
     * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET",
     * "name": "GET",
     * "title": "GET"
     * },
     * "integration:put": {
     * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
     * },
     * "method:delete": {
     * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
     * },
     * "method:integration": {
     * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
     * },
     * "method:responses": {
     * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
     * "name": "200",
     * "title": "200"
     * },
     * "method:update": {
     * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
     * },
     * "methodresponse:put": {
     * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/{status_code}",
     * "templated": true
     * }
     * },
     * "apiKeyRequired": false,
     * "authorizationType": "NONE",
     * "httpMethod": "GET",
     * "_embedded": {
     * "method:integration": {
     * "_links": {
     * "self": {
     * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
     * },
     * "integration:delete": {
     * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
     * },
     * "integration:responses": {
     * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
     * "name": "200",
     * "title": "200"
     * },
     * "integration:update": {
     * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
     * },
     * "integrationresponse:put": {
     * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/{status_code}",
     * "templated": true
     * }
     * },
     * "cacheKeyParameters": &#91;&#93;,
     * "cacheNamespace": "3kzxbg5sa2",
     * "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
     * "httpMethod": "POST",
     * "passthroughBehavior": "WHEN_NO_MATCH",
     * "requestParameters": {
     * "integration.request.header.Content-Type": "'application/x-amz-json-1.1'"
     * },
     * "requestTemplates": {
     * "application/json": "{\n}"
     * },
     * "type": "AWS",
     * "uri": "arn:aws:apigateway:us-east-1:kinesis:action/ListStreams",
     * "_embedded": {
     * "integration:responses": {
     * "_links": {
     * "self": {
     * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
     * "name": "200",
     * "title": "200"
     * },
     * "integrationresponse:delete": {
     * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
     * },
     * "integrationresponse:update": {
     * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
     * }
     * },
     * "responseParameters": {
     * "method.response.header.Content-Type": "'application/xml'"
     * },
     * "responseTemplates": {
     * "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
     * },
     * "statusCode": "200"
     * }
     * }
     * },
     * "method:responses": {
     * "_links": {
     * "self": {
     * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
     * "name": "200",
     * "title": "200"
     * },
     * "methodresponse:delete": {
     * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
     * },
     * "methodresponse:update": {
     * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
     * }
     * },
     * "responseModels": {
     * "application/json": "Empty"
     * },
     * "responseParameters": {
     * "method.response.header.Content-Type": false
     * },
     * "statusCode": "200"
     * }
     * }
     * }</pre>
     * If the OPTIONS is enabled on the resource, you can follow the example here to get that method. Just replace the GET of the last path segment in the request URL with OPTIONS.
     * </div>
     * <div class="seeAlso">
     * </div>
     */
    val resourceMethods: Map<String, Method>? = builder.resourceMethods

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.GetResourceResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetResourceResponse(")
        append("id=$id,")
        append("parentId=$parentId,")
        append("path=$path,")
        append("pathPart=$pathPart,")
        append("resourceMethods=$resourceMethods)")
    }

    override fun hashCode(): kotlin.Int {
        var result = id?.hashCode() ?: 0
        result = 31 * result + (parentId?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (pathPart?.hashCode() ?: 0)
        result = 31 * result + (resourceMethods?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetResourceResponse

        if (id != other.id) return false
        if (parentId != other.parentId) return false
        if (path != other.path) return false
        if (pathPart != other.pathPart) return false
        if (resourceMethods != other.resourceMethods) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.GetResourceResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The resource's identifier.
         */
        var id: kotlin.String? = null
        /**
         * The parent resource's identifier.
         */
        var parentId: kotlin.String? = null
        /**
         * The full path for this resource.
         */
        var path: kotlin.String? = null
        /**
         * The last path segment for this resource.
         */
        var pathPart: kotlin.String? = null
        /**
         * Gets an API resource's method of a given HTTP verb.
         * <div class="remarks">
         * The resource methods are a map of methods indexed by methods' HTTP verbs enabled on the resource. This method map is included in the 200 OK response of the GET /restapis/{restapi_id}/resources/{resource_id} or GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods request.
         * <h4>Example: Get the GET method of an API resource</h4>
         * <h5>Request</h5>
         * <pre>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET HTTP/1.1
         * Content-Type: application/json
         * Host: apigateway.us-east-1.amazonaws.com
         * X-Amz-Date: 20170223T031827Z
         * Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20170223/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</pre>
         * <h5>Response</h5>
         * <pre>{
         * "_links": {
         * "curies": &#91;
         * {
         * "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
         * "name": "integration",
         * "templated": true
         * },
         * {
         * "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
         * "name": "integrationresponse",
         * "templated": true
         * },
         * {
         * "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-{rel}.html",
         * "name": "method",
         * "templated": true
         * },
         * {
         * "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
         * "name": "methodresponse",
         * "templated": true
         * }
         * &#93;,
         * "self": {
         * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET",
         * "name": "GET",
         * "title": "GET"
         * },
         * "integration:put": {
         * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
         * },
         * "method:delete": {
         * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
         * },
         * "method:integration": {
         * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
         * },
         * "method:responses": {
         * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
         * "name": "200",
         * "title": "200"
         * },
         * "method:update": {
         * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
         * },
         * "methodresponse:put": {
         * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/{status_code}",
         * "templated": true
         * }
         * },
         * "apiKeyRequired": false,
         * "authorizationType": "NONE",
         * "httpMethod": "GET",
         * "_embedded": {
         * "method:integration": {
         * "_links": {
         * "self": {
         * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
         * },
         * "integration:delete": {
         * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
         * },
         * "integration:responses": {
         * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
         * "name": "200",
         * "title": "200"
         * },
         * "integration:update": {
         * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
         * },
         * "integrationresponse:put": {
         * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/{status_code}",
         * "templated": true
         * }
         * },
         * "cacheKeyParameters": &#91;&#93;,
         * "cacheNamespace": "3kzxbg5sa2",
         * "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
         * "httpMethod": "POST",
         * "passthroughBehavior": "WHEN_NO_MATCH",
         * "requestParameters": {
         * "integration.request.header.Content-Type": "'application/x-amz-json-1.1'"
         * },
         * "requestTemplates": {
         * "application/json": "{\n}"
         * },
         * "type": "AWS",
         * "uri": "arn:aws:apigateway:us-east-1:kinesis:action/ListStreams",
         * "_embedded": {
         * "integration:responses": {
         * "_links": {
         * "self": {
         * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
         * "name": "200",
         * "title": "200"
         * },
         * "integrationresponse:delete": {
         * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
         * },
         * "integrationresponse:update": {
         * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
         * }
         * },
         * "responseParameters": {
         * "method.response.header.Content-Type": "'application/xml'"
         * },
         * "responseTemplates": {
         * "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
         * },
         * "statusCode": "200"
         * }
         * }
         * },
         * "method:responses": {
         * "_links": {
         * "self": {
         * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
         * "name": "200",
         * "title": "200"
         * },
         * "methodresponse:delete": {
         * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
         * },
         * "methodresponse:update": {
         * "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
         * }
         * },
         * "responseModels": {
         * "application/json": "Empty"
         * },
         * "responseParameters": {
         * "method.response.header.Content-Type": false
         * },
         * "statusCode": "200"
         * }
         * }
         * }</pre>
         * If the OPTIONS is enabled on the resource, you can follow the example here to get that method. Just replace the GET of the last path segment in the request URL with OPTIONS.
         * </div>
         * <div class="seeAlso">
         * </div>
         */
        var resourceMethods: Map<String, Method>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.GetResourceResponse) : this() {
            this.id = x.id
            this.parentId = x.parentId
            this.path = x.path
            this.pathPart = x.pathPart
            this.resourceMethods = x.resourceMethods
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.GetResourceResponse = GetResourceResponse(this)
    }
}
