// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Represents a put integration response request.
 */
class PutIntegrationResponseRequest private constructor(builder: Builder) {
    /**
     * Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
     *
     * CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.
     * CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
     *
     * If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.
     */
    val contentHandling: aws.sdk.kotlin.services.apigateway.model.ContentHandlingStrategy? = builder.contentHandling
    /**
     * &#91;Required&#93; Specifies a put integration response request's HTTP method.
     */
    val httpMethod: kotlin.String? = builder.httpMethod
    /**
     * &#91;Required&#93; Specifies a put integration response request's resource identifier.
     */
    val resourceId: kotlin.String? = builder.resourceId
    /**
     * A key-value map specifying response parameters that are passed to the method response from the back end.
     * The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where name must be a valid and unique response header name and JSON-expression a valid JSON expression without the $ prefix.
     */
    val responseParameters: Map<String, String>? = builder.responseParameters
    /**
     * Specifies a put integration response's templates.
     */
    val responseTemplates: Map<String, String>? = builder.responseTemplates
    /**
     * &#91;Required&#93; The string identifier of the associated RestApi.
     */
    val restApiId: kotlin.String? = builder.restApiId
    /**
     * Specifies the selection pattern of a put integration response.
     */
    val selectionPattern: kotlin.String? = builder.selectionPattern
    /**
     * &#91;Required&#93; Specifies the status code that is used to map the integration response to an existing MethodResponse.
     */
    val statusCode: kotlin.String? = builder.statusCode

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.PutIntegrationResponseRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutIntegrationResponseRequest(")
        append("contentHandling=$contentHandling,")
        append("httpMethod=$httpMethod,")
        append("resourceId=$resourceId,")
        append("responseParameters=$responseParameters,")
        append("responseTemplates=$responseTemplates,")
        append("restApiId=$restApiId,")
        append("selectionPattern=$selectionPattern,")
        append("statusCode=$statusCode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = contentHandling?.hashCode() ?: 0
        result = 31 * result + (httpMethod?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (responseParameters?.hashCode() ?: 0)
        result = 31 * result + (responseTemplates?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        result = 31 * result + (selectionPattern?.hashCode() ?: 0)
        result = 31 * result + (statusCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutIntegrationResponseRequest

        if (contentHandling != other.contentHandling) return false
        if (httpMethod != other.httpMethod) return false
        if (resourceId != other.resourceId) return false
        if (responseParameters != other.responseParameters) return false
        if (responseTemplates != other.responseTemplates) return false
        if (restApiId != other.restApiId) return false
        if (selectionPattern != other.selectionPattern) return false
        if (statusCode != other.statusCode) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.PutIntegrationResponseRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
         *
         * CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.
         * CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
         *
         * If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.
         */
        var contentHandling: aws.sdk.kotlin.services.apigateway.model.ContentHandlingStrategy? = null
        /**
         * &#91;Required&#93; Specifies a put integration response request's HTTP method.
         */
        var httpMethod: kotlin.String? = null
        /**
         * &#91;Required&#93; Specifies a put integration response request's resource identifier.
         */
        var resourceId: kotlin.String? = null
        /**
         * A key-value map specifying response parameters that are passed to the method response from the back end.
         * The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where name must be a valid and unique response header name and JSON-expression a valid JSON expression without the $ prefix.
         */
        var responseParameters: Map<String, String>? = null
        /**
         * Specifies a put integration response's templates.
         */
        var responseTemplates: Map<String, String>? = null
        /**
         * &#91;Required&#93; The string identifier of the associated RestApi.
         */
        var restApiId: kotlin.String? = null
        /**
         * Specifies the selection pattern of a put integration response.
         */
        var selectionPattern: kotlin.String? = null
        /**
         * &#91;Required&#93; Specifies the status code that is used to map the integration response to an existing MethodResponse.
         */
        var statusCode: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.PutIntegrationResponseRequest) : this() {
            this.contentHandling = x.contentHandling
            this.httpMethod = x.httpMethod
            this.resourceId = x.resourceId
            this.responseParameters = x.responseParameters
            this.responseTemplates = x.responseTemplates
            this.restApiId = x.restApiId
            this.selectionPattern = x.selectionPattern
            this.statusCode = x.statusCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.PutIntegrationResponseRequest = PutIntegrationResponseRequest(this)
    }
}
