// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Represents a usage plan used to specify who can assess associated API stages. Optionally, target request rate and quota limits can be set.
 * In some cases clients can exceed the targets that you set. Don’t rely on usage plans to control costs.
 * Consider using <a href="https://docs.aws.amazon.com/cost-management/latest/userguide/budgets-managing-costs.html">AWS Budgets to monitor costs
 * and <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF to manage API requests.
 * <div class="remarks">
 * In a usage plan, you associate an API by specifying the API's Id and a stage name of the specified API. You add plan customers by adding API keys to the plan.
 * </div>
 * <div class="seeAlso">
 * <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html">Create and Use Usage Plans
 * </div>
 */
class UpdateUsagePlanResponse private constructor(builder: Builder) {
    /**
     * The associated API stages of a usage plan.
     */
    val apiStages: List<ApiStage>? = builder.apiStages
    /**
     * The description of a usage plan.
     */
    val description: kotlin.String? = builder.description
    /**
     * The identifier of a UsagePlan resource.
     */
    val id: kotlin.String? = builder.id
    /**
     * The name of a usage plan.
     */
    val name: kotlin.String? = builder.name
    /**
     * The AWS Markeplace product identifier to associate with the usage plan as a SaaS product on AWS Marketplace.
     */
    val productCode: kotlin.String? = builder.productCode
    /**
     * The target maximum number of permitted requests per a given unit time interval.
     */
    val quota: aws.sdk.kotlin.services.apigateway.model.QuotaSettings? = builder.quota
    /**
     * The collection of tags. Each tag element is associated with a given resource.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * Map containing method level throttling information for API stage in a usage plan.
     */
    val throttle: aws.sdk.kotlin.services.apigateway.model.ThrottleSettings? = builder.throttle

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.UpdateUsagePlanResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateUsagePlanResponse(")
        append("apiStages=$apiStages,")
        append("description=$description,")
        append("id=$id,")
        append("name=$name,")
        append("productCode=$productCode,")
        append("quota=$quota,")
        append("tags=$tags,")
        append("throttle=$throttle)")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiStages?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (productCode?.hashCode() ?: 0)
        result = 31 * result + (quota?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (throttle?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateUsagePlanResponse

        if (apiStages != other.apiStages) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (productCode != other.productCode) return false
        if (quota != other.quota) return false
        if (tags != other.tags) return false
        if (throttle != other.throttle) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.UpdateUsagePlanResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The associated API stages of a usage plan.
         */
        var apiStages: List<ApiStage>? = null
        /**
         * The description of a usage plan.
         */
        var description: kotlin.String? = null
        /**
         * The identifier of a UsagePlan resource.
         */
        var id: kotlin.String? = null
        /**
         * The name of a usage plan.
         */
        var name: kotlin.String? = null
        /**
         * The AWS Markeplace product identifier to associate with the usage plan as a SaaS product on AWS Marketplace.
         */
        var productCode: kotlin.String? = null
        /**
         * The target maximum number of permitted requests per a given unit time interval.
         */
        var quota: aws.sdk.kotlin.services.apigateway.model.QuotaSettings? = null
        /**
         * The collection of tags. Each tag element is associated with a given resource.
         */
        var tags: Map<String, String>? = null
        /**
         * Map containing method level throttling information for API stage in a usage plan.
         */
        var throttle: aws.sdk.kotlin.services.apigateway.model.ThrottleSettings? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.UpdateUsagePlanResponse) : this() {
            this.apiStages = x.apiStages
            this.description = x.description
            this.id = x.id
            this.name = x.name
            this.productCode = x.productCode
            this.quota = x.quota
            this.tags = x.tags
            this.throttle = x.throttle
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.UpdateUsagePlanResponse = UpdateUsagePlanResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.QuotaSettings] inside the given [block]
         */
        fun quota(block: aws.sdk.kotlin.services.apigateway.model.QuotaSettings.Builder.() -> kotlin.Unit) {
            this.quota = aws.sdk.kotlin.services.apigateway.model.QuotaSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.ThrottleSettings] inside the given [block]
         */
        fun throttle(block: aws.sdk.kotlin.services.apigateway.model.ThrottleSettings.Builder.() -> kotlin.Unit) {
            this.throttle = aws.sdk.kotlin.services.apigateway.model.ThrottleSettings.invoke(block)
        }
    }
}
