// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Gets the documentation parts of an API. The result may be filtered by the type, name, or path of API entities (targets).
 */
public class GetDocumentationPartsRequest private constructor(builder: Builder) {
    /**
     * The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
     */
    public val limit: kotlin.Int? = builder.limit
    /**
     * The status of the API documentation parts to retrieve. Valid values are `DOCUMENTED` for retrieving DocumentationPart resources with content and `UNDOCUMENTED` for DocumentationPart resources without content.
     */
    public val locationStatus: aws.sdk.kotlin.services.apigateway.model.LocationStatusType? = builder.locationStatus
    /**
     * The name of API entities of the to-be-retrieved documentation parts.
     */
    public val nameQuery: kotlin.String? = builder.nameQuery
    /**
     * The path of API entities of the to-be-retrieved documentation parts.
     */
    public val path: kotlin.String? = builder.path
    /**
     * The current pagination position in the paged result set.
     */
    public val position: kotlin.String? = builder.position
    /**
     * The string identifier of the associated RestApi.
     */
    public val restApiId: kotlin.String? = requireNotNull(builder.restApiId) { "A non-null value must be provided for restApiId" }
    /**
     * The type of API entities of the to-be-retrieved documentation parts.
     */
    public val type: aws.sdk.kotlin.services.apigateway.model.DocumentationPartType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.GetDocumentationPartsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetDocumentationPartsRequest(")
        append("limit=$limit,")
        append("locationStatus=$locationStatus,")
        append("nameQuery=$nameQuery,")
        append("path=$path,")
        append("position=$position,")
        append("restApiId=$restApiId,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = limit ?: 0
        result = 31 * result + (locationStatus?.hashCode() ?: 0)
        result = 31 * result + (nameQuery?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (position?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetDocumentationPartsRequest

        if (limit != other.limit) return false
        if (locationStatus != other.locationStatus) return false
        if (nameQuery != other.nameQuery) return false
        if (path != other.path) return false
        if (position != other.position) return false
        if (restApiId != other.restApiId) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.GetDocumentationPartsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
         */
        public var limit: kotlin.Int? = null
        /**
         * The status of the API documentation parts to retrieve. Valid values are `DOCUMENTED` for retrieving DocumentationPart resources with content and `UNDOCUMENTED` for DocumentationPart resources without content.
         */
        public var locationStatus: aws.sdk.kotlin.services.apigateway.model.LocationStatusType? = null
        /**
         * The name of API entities of the to-be-retrieved documentation parts.
         */
        public var nameQuery: kotlin.String? = null
        /**
         * The path of API entities of the to-be-retrieved documentation parts.
         */
        public var path: kotlin.String? = null
        /**
         * The current pagination position in the paged result set.
         */
        public var position: kotlin.String? = null
        /**
         * The string identifier of the associated RestApi.
         */
        public var restApiId: kotlin.String? = null
        /**
         * The type of API entities of the to-be-retrieved documentation parts.
         */
        public var type: aws.sdk.kotlin.services.apigateway.model.DocumentationPartType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.GetDocumentationPartsRequest) : this() {
            this.limit = x.limit
            this.locationStatus = x.locationStatus
            this.nameQuery = x.nameQuery
            this.path = x.path
            this.position = x.position
            this.restApiId = x.restApiId
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.GetDocumentationPartsRequest = GetDocumentationPartsRequest(this)
    }
}
