// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * The POST request to import API keys from an external source, such as a CSV-formatted file.
 */
public class ImportApiKeysRequest private constructor(builder: Builder) {
    /**
     * The payload of the POST request to import API keys. For the payload format, see API Key File Format.
     */
    public val body: kotlin.ByteArray? = builder.body
    /**
     * A query parameter to indicate whether to rollback ApiKey importation (`true`) or not (`false`) when error is encountered.
     */
    public val failOnWarnings: kotlin.Boolean = builder.failOnWarnings
    /**
     * A query parameter to specify the input format to imported API keys. Currently, only the `csv` format is supported.
     */
    public val format: aws.sdk.kotlin.services.apigateway.model.ApiKeysFormat? = builder.format

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.ImportApiKeysRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImportApiKeysRequest(")
        append("body=$body,")
        append("failOnWarnings=$failOnWarnings,")
        append("format=$format)")
    }

    override fun hashCode(): kotlin.Int {
        var result = body?.contentHashCode() ?: 0
        result = 31 * result + (failOnWarnings.hashCode())
        result = 31 * result + (format?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImportApiKeysRequest

        if (body != null) {
            if (other.body == null) return false
            if (!body.contentEquals(other.body)) return false
        } else if (other.body != null) return false
        if (failOnWarnings != other.failOnWarnings) return false
        if (format != other.format) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.ImportApiKeysRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The payload of the POST request to import API keys. For the payload format, see API Key File Format.
         */
        public var body: kotlin.ByteArray? = null
        /**
         * A query parameter to indicate whether to rollback ApiKey importation (`true`) or not (`false`) when error is encountered.
         */
        public var failOnWarnings: kotlin.Boolean = false
        /**
         * A query parameter to specify the input format to imported API keys. Currently, only the `csv` format is supported.
         */
        public var format: aws.sdk.kotlin.services.apigateway.model.ApiKeysFormat? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.ImportApiKeysRequest) : this() {
            this.body = x.body
            this.failOnWarnings = x.failOnWarnings
            this.format = x.format
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.ImportApiKeysRequest = ImportApiKeysRequest(this)
    }
}
