// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Represents a client-facing interface by which the client calls the API to access back-end resources. A Method resource is integrated with an Integration resource. Both consist of a request and one or more responses. The method request takes the client input that is passed to the back end through the integration request. A method response returns the output from the back end to the client through an integration response. A method request is embodied in a Method resource, whereas an integration request is embodied in an Integration resource. On the other hand, a method response is represented by a MethodResponse resource, whereas an integration response is represented by an IntegrationResponse resource.
 */
public class Method private constructor(builder: Builder) {
    /**
     * A boolean flag specifying whether a valid ApiKey is required to invoke this method.
     */
    public val apiKeyRequired: kotlin.Boolean? = builder.apiKeyRequired
    /**
     * A list of authorization scopes configured on the method. The scopes are used with a `COGNITO_USER_POOLS` authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.
     */
    public val authorizationScopes: List<String>? = builder.authorizationScopes
    /**
     * The method's authorization type. Valid values are `NONE` for open access, `AWS_IAM` for using AWS IAM permissions, `CUSTOM` for using a custom authorizer, or `COGNITO_USER_POOLS` for using a Cognito user pool.
     */
    public val authorizationType: kotlin.String? = builder.authorizationType
    /**
     * The identifier of an Authorizer to use on this method. The `authorizationType` must be `CUSTOM`.
     */
    public val authorizerId: kotlin.String? = builder.authorizerId
    /**
     * The method's HTTP verb.
     */
    public val httpMethod: kotlin.String? = builder.httpMethod
    /**
     * Gets the method's integration responsible for passing the client-submitted request to the back end and performing necessary transformations to make the request compliant with the back end.
     */
    public val methodIntegration: aws.sdk.kotlin.services.apigateway.model.Integration? = builder.methodIntegration
    /**
     * Gets a method response associated with a given HTTP status code.
     */
    public val methodResponses: Map<String, MethodResponse>? = builder.methodResponses
    /**
     * A human-friendly operation identifier for the method. For example, you can assign the `operationName` of `ListPets` for the `GET /pets` method in the `PetStore` example.
     */
    public val operationName: kotlin.String? = builder.operationName
    /**
     * A key-value map specifying data schemas, represented by Model resources, (as the mapped value) of the request payloads of given content types (as the mapping key).
     */
    public val requestModels: Map<String, String>? = builder.requestModels
    /**
     * A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key is a method request parameter name matching the pattern of `method.request.{location}.{name}`, where `location` is `querystring`, `path`, or `header` and `name` is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (`true`) or optional (`false`). The method request parameter names defined here are available in Integration to be mapped to integration request parameters or templates.
     */
    public val requestParameters: Map<String, Boolean>? = builder.requestParameters
    /**
     * The identifier of a RequestValidator for request validation.
     */
    public val requestValidatorId: kotlin.String? = builder.requestValidatorId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.Method = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Method(")
        append("apiKeyRequired=$apiKeyRequired,")
        append("authorizationScopes=$authorizationScopes,")
        append("authorizationType=$authorizationType,")
        append("authorizerId=$authorizerId,")
        append("httpMethod=$httpMethod,")
        append("methodIntegration=$methodIntegration,")
        append("methodResponses=$methodResponses,")
        append("operationName=$operationName,")
        append("requestModels=$requestModels,")
        append("requestParameters=$requestParameters,")
        append("requestValidatorId=$requestValidatorId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiKeyRequired?.hashCode() ?: 0
        result = 31 * result + (authorizationScopes?.hashCode() ?: 0)
        result = 31 * result + (authorizationType?.hashCode() ?: 0)
        result = 31 * result + (authorizerId?.hashCode() ?: 0)
        result = 31 * result + (httpMethod?.hashCode() ?: 0)
        result = 31 * result + (methodIntegration?.hashCode() ?: 0)
        result = 31 * result + (methodResponses?.hashCode() ?: 0)
        result = 31 * result + (operationName?.hashCode() ?: 0)
        result = 31 * result + (requestModels?.hashCode() ?: 0)
        result = 31 * result + (requestParameters?.hashCode() ?: 0)
        result = 31 * result + (requestValidatorId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Method

        if (apiKeyRequired != other.apiKeyRequired) return false
        if (authorizationScopes != other.authorizationScopes) return false
        if (authorizationType != other.authorizationType) return false
        if (authorizerId != other.authorizerId) return false
        if (httpMethod != other.httpMethod) return false
        if (methodIntegration != other.methodIntegration) return false
        if (methodResponses != other.methodResponses) return false
        if (operationName != other.operationName) return false
        if (requestModels != other.requestModels) return false
        if (requestParameters != other.requestParameters) return false
        if (requestValidatorId != other.requestValidatorId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.Method = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A boolean flag specifying whether a valid ApiKey is required to invoke this method.
         */
        public var apiKeyRequired: kotlin.Boolean? = null
        /**
         * A list of authorization scopes configured on the method. The scopes are used with a `COGNITO_USER_POOLS` authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.
         */
        public var authorizationScopes: List<String>? = null
        /**
         * The method's authorization type. Valid values are `NONE` for open access, `AWS_IAM` for using AWS IAM permissions, `CUSTOM` for using a custom authorizer, or `COGNITO_USER_POOLS` for using a Cognito user pool.
         */
        public var authorizationType: kotlin.String? = null
        /**
         * The identifier of an Authorizer to use on this method. The `authorizationType` must be `CUSTOM`.
         */
        public var authorizerId: kotlin.String? = null
        /**
         * The method's HTTP verb.
         */
        public var httpMethod: kotlin.String? = null
        /**
         * Gets the method's integration responsible for passing the client-submitted request to the back end and performing necessary transformations to make the request compliant with the back end.
         */
        public var methodIntegration: aws.sdk.kotlin.services.apigateway.model.Integration? = null
        /**
         * Gets a method response associated with a given HTTP status code.
         */
        public var methodResponses: Map<String, MethodResponse>? = null
        /**
         * A human-friendly operation identifier for the method. For example, you can assign the `operationName` of `ListPets` for the `GET /pets` method in the `PetStore` example.
         */
        public var operationName: kotlin.String? = null
        /**
         * A key-value map specifying data schemas, represented by Model resources, (as the mapped value) of the request payloads of given content types (as the mapping key).
         */
        public var requestModels: Map<String, String>? = null
        /**
         * A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key is a method request parameter name matching the pattern of `method.request.{location}.{name}`, where `location` is `querystring`, `path`, or `header` and `name` is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (`true`) or optional (`false`). The method request parameter names defined here are available in Integration to be mapped to integration request parameters or templates.
         */
        public var requestParameters: Map<String, Boolean>? = null
        /**
         * The identifier of a RequestValidator for request validation.
         */
        public var requestValidatorId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.Method) : this() {
            this.apiKeyRequired = x.apiKeyRequired
            this.authorizationScopes = x.authorizationScopes
            this.authorizationType = x.authorizationType
            this.authorizerId = x.authorizerId
            this.httpMethod = x.httpMethod
            this.methodIntegration = x.methodIntegration
            this.methodResponses = x.methodResponses
            this.operationName = x.operationName
            this.requestModels = x.requestModels
            this.requestParameters = x.requestParameters
            this.requestValidatorId = x.requestValidatorId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.Method = Method(this)

        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.Integration] inside the given [block]
         */
        public fun methodIntegration(block: aws.sdk.kotlin.services.apigateway.model.Integration.Builder.() -> kotlin.Unit) {
            this.methodIntegration = aws.sdk.kotlin.services.apigateway.model.Integration.invoke(block)
        }
    }
}
