// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An immutable representation of a RestApi resource that can be called by users using Stages. A deployment must be associated with a Stage for it to be callable over the Internet.
 */
public class UpdateDeploymentResponse private constructor(builder: Builder) {
    /**
     * A summary of the RestApi at the date and time that the deployment resource was created.
     */
    public val apiSummary: Map<String, Map<String, MethodSnapshot>>? = builder.apiSummary
    /**
     * The date and time that the deployment resource was created.
     */
    public val createdDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createdDate
    /**
     * The description for the deployment resource.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The identifier for the deployment resource.
     */
    public val id: kotlin.String? = builder.id

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.UpdateDeploymentResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateDeploymentResponse(")
        append("apiSummary=$apiSummary,")
        append("createdDate=$createdDate,")
        append("description=$description,")
        append("id=$id)")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiSummary?.hashCode() ?: 0
        result = 31 * result + (createdDate?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateDeploymentResponse

        if (apiSummary != other.apiSummary) return false
        if (createdDate != other.createdDate) return false
        if (description != other.description) return false
        if (id != other.id) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.UpdateDeploymentResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A summary of the RestApi at the date and time that the deployment resource was created.
         */
        public var apiSummary: Map<String, Map<String, MethodSnapshot>>? = null
        /**
         * The date and time that the deployment resource was created.
         */
        public var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description for the deployment resource.
         */
        public var description: kotlin.String? = null
        /**
         * The identifier for the deployment resource.
         */
        public var id: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.UpdateDeploymentResponse) : this() {
            this.apiSummary = x.apiSummary
            this.createdDate = x.createdDate
            this.description = x.description
            this.id = x.id
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.UpdateDeploymentResponse = UpdateDeploymentResponse(this)
    }
}
