// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.apigatewayv2.model.ApiGatewayV2Exception
import aws.sdk.kotlin.services.apigatewayv2.model.DeploymentStatus
import aws.sdk.kotlin.services.apigatewayv2.model.UpdateDeploymentResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class UpdateDeploymentOperationDeserializer: HttpDeserialize<UpdateDeploymentResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateDeploymentResponse {
        if (!response.status.isSuccess()) {
            throwUpdateDeploymentError(context, response)
        }
        val builder = UpdateDeploymentResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateDeploymentOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateDeploymentError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ApiGatewayV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ApiGatewayV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateDeploymentOperationBody(builder: UpdateDeploymentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUTODEPLOYED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("autoDeployed"))
    val CREATEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdDate"))
    val DEPLOYMENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("deploymentId"))
    val DEPLOYMENTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("deploymentStatus"))
    val DEPLOYMENTSTATUSMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("deploymentStatusMessage"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTODEPLOYED_DESCRIPTOR)
        field(CREATEDDATE_DESCRIPTOR)
        field(DEPLOYMENTID_DESCRIPTOR)
        field(DEPLOYMENTSTATUS_DESCRIPTOR)
        field(DEPLOYMENTSTATUSMESSAGE_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTODEPLOYED_DESCRIPTOR.index -> builder.autoDeployed = deserializeBoolean()
                CREATEDDATE_DESCRIPTOR.index -> builder.createdDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                DEPLOYMENTID_DESCRIPTOR.index -> builder.deploymentId = deserializeString()
                DEPLOYMENTSTATUS_DESCRIPTOR.index -> builder.deploymentStatus = deserializeString().let { DeploymentStatus.fromValue(it) }
                DEPLOYMENTSTATUSMESSAGE_DESCRIPTOR.index -> builder.deploymentStatusMessage = deserializeString()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
