// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.transform

import aws.sdk.kotlin.services.apigatewayv2.model.AccessLogSettings
import aws.sdk.kotlin.services.apigatewayv2.model.RouteSettings
import aws.sdk.kotlin.services.apigatewayv2.model.UpdateStageRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateStageOperationSerializer: HttpSerialize<UpdateStageRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateStageRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            val pathSegments = listOf(
                "v2",
                "apis",
                "${input.apiId}".encodeLabel(),
                "stages",
                "${input.stageName}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateStageOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateStageOperationBody(context: ExecutionContext, input: UpdateStageRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACCESSLOGSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("accessLogSettings"))
    val AUTODEPLOY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("autoDeploy"))
    val CLIENTCERTIFICATEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientCertificateId"))
    val DEFAULTROUTESETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("defaultRouteSettings"))
    val DEPLOYMENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("deploymentId"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val ROUTESETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("routeSettings"))
    val STAGEVARIABLES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("stageVariables"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCESSLOGSETTINGS_DESCRIPTOR)
        field(AUTODEPLOY_DESCRIPTOR)
        field(CLIENTCERTIFICATEID_DESCRIPTOR)
        field(DEFAULTROUTESETTINGS_DESCRIPTOR)
        field(DEPLOYMENTID_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ROUTESETTINGS_DESCRIPTOR)
        field(STAGEVARIABLES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.accessLogSettings?.let { field(ACCESSLOGSETTINGS_DESCRIPTOR, it, ::serializeAccessLogSettingsDocument) }
        input.autoDeploy?.let { field(AUTODEPLOY_DESCRIPTOR, it) }
        input.clientCertificateId?.let { field(CLIENTCERTIFICATEID_DESCRIPTOR, it) }
        input.defaultRouteSettings?.let { field(DEFAULTROUTESETTINGS_DESCRIPTOR, it, ::serializeRouteSettingsDocument) }
        input.deploymentId?.let { field(DEPLOYMENTID_DESCRIPTOR, it) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        if (input.routeSettings != null) {
            mapField(ROUTESETTINGS_DESCRIPTOR) {
                input.routeSettings.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeRouteSettingsDocument)) }
            }
        }
        if (input.stageVariables != null) {
            mapField(STAGEVARIABLES_DESCRIPTOR) {
                input.stageVariables.forEach { (key, value) -> entry(key, value) }
            }
        }
    }
    return serializer.toByteArray()
}
