// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.model

import aws.smithy.kotlin.runtime.time.Instant

public class CreateApiResponse private constructor(builder: Builder) {
    /**
     * The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended to this URI to form a complete path to a deployed API stage.
     */
    public val apiEndpoint: kotlin.String? = builder.apiEndpoint
    /**
     * Specifies whether an API is managed by API Gateway. You can't update or delete a managed API by using API Gateway. A managed API can be deleted only through the tooling or service that created it.
     */
    public val apiGatewayManaged: kotlin.Boolean? = builder.apiGatewayManaged
    /**
     * The API ID.
     */
    public val apiId: kotlin.String? = builder.apiId
    /**
     * An API key selection expression. Supported only for WebSocket APIs. See [API Key Selection Expressions](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions).
     */
    public val apiKeySelectionExpression: kotlin.String? = builder.apiKeySelectionExpression
    /**
     * A CORS configuration. Supported only for HTTP APIs.
     */
    public val corsConfiguration: aws.sdk.kotlin.services.apigatewayv2.model.Cors? = builder.corsConfiguration
    /**
     * The timestamp when the API was created.
     */
    public val createdDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createdDate
    /**
     * The description of the API.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.
     */
    public val disableExecuteApiEndpoint: kotlin.Boolean? = builder.disableExecuteApiEndpoint
    /**
     * Avoid validating models when creating a deployment. Supported only for WebSocket APIs.
     */
    public val disableSchemaValidation: kotlin.Boolean? = builder.disableSchemaValidation
    /**
     * The validation information during API import. This may include particular properties of your OpenAPI definition which are ignored during import. Supported only for HTTP APIs.
     */
    public val importInfo: List<String>? = builder.importInfo
    /**
     * The name of the API.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The API protocol.
     */
    public val protocolType: aws.sdk.kotlin.services.apigatewayv2.model.ProtocolType? = builder.protocolType
    /**
     * The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.
     */
    public val routeSelectionExpression: kotlin.String? = builder.routeSelectionExpression
    /**
     * A collection of tags associated with the API.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * A version identifier for the API.
     */
    public val version: kotlin.String? = builder.version
    /**
     * The warning messages reported when failonwarnings is turned on during API import.
     */
    public val warnings: List<String>? = builder.warnings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigatewayv2.model.CreateApiResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateApiResponse(")
        append("apiEndpoint=$apiEndpoint,")
        append("apiGatewayManaged=$apiGatewayManaged,")
        append("apiId=$apiId,")
        append("apiKeySelectionExpression=$apiKeySelectionExpression,")
        append("corsConfiguration=$corsConfiguration,")
        append("createdDate=$createdDate,")
        append("description=$description,")
        append("disableExecuteApiEndpoint=$disableExecuteApiEndpoint,")
        append("disableSchemaValidation=$disableSchemaValidation,")
        append("importInfo=$importInfo,")
        append("name=$name,")
        append("protocolType=$protocolType,")
        append("routeSelectionExpression=$routeSelectionExpression,")
        append("tags=$tags,")
        append("version=$version,")
        append("warnings=$warnings)")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiEndpoint?.hashCode() ?: 0
        result = 31 * result + (apiGatewayManaged?.hashCode() ?: 0)
        result = 31 * result + (apiId?.hashCode() ?: 0)
        result = 31 * result + (apiKeySelectionExpression?.hashCode() ?: 0)
        result = 31 * result + (corsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (createdDate?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (disableExecuteApiEndpoint?.hashCode() ?: 0)
        result = 31 * result + (disableSchemaValidation?.hashCode() ?: 0)
        result = 31 * result + (importInfo?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (protocolType?.hashCode() ?: 0)
        result = 31 * result + (routeSelectionExpression?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        result = 31 * result + (warnings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateApiResponse

        if (apiEndpoint != other.apiEndpoint) return false
        if (apiGatewayManaged != other.apiGatewayManaged) return false
        if (apiId != other.apiId) return false
        if (apiKeySelectionExpression != other.apiKeySelectionExpression) return false
        if (corsConfiguration != other.corsConfiguration) return false
        if (createdDate != other.createdDate) return false
        if (description != other.description) return false
        if (disableExecuteApiEndpoint != other.disableExecuteApiEndpoint) return false
        if (disableSchemaValidation != other.disableSchemaValidation) return false
        if (importInfo != other.importInfo) return false
        if (name != other.name) return false
        if (protocolType != other.protocolType) return false
        if (routeSelectionExpression != other.routeSelectionExpression) return false
        if (tags != other.tags) return false
        if (version != other.version) return false
        if (warnings != other.warnings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigatewayv2.model.CreateApiResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com. The stage name is typically appended to this URI to form a complete path to a deployed API stage.
         */
        public var apiEndpoint: kotlin.String? = null
        /**
         * Specifies whether an API is managed by API Gateway. You can't update or delete a managed API by using API Gateway. A managed API can be deleted only through the tooling or service that created it.
         */
        public var apiGatewayManaged: kotlin.Boolean? = null
        /**
         * The API ID.
         */
        public var apiId: kotlin.String? = null
        /**
         * An API key selection expression. Supported only for WebSocket APIs. See [API Key Selection Expressions](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions).
         */
        public var apiKeySelectionExpression: kotlin.String? = null
        /**
         * A CORS configuration. Supported only for HTTP APIs.
         */
        public var corsConfiguration: aws.sdk.kotlin.services.apigatewayv2.model.Cors? = null
        /**
         * The timestamp when the API was created.
         */
        public var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the API.
         */
        public var description: kotlin.String? = null
        /**
         * Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.
         */
        public var disableExecuteApiEndpoint: kotlin.Boolean? = null
        /**
         * Avoid validating models when creating a deployment. Supported only for WebSocket APIs.
         */
        public var disableSchemaValidation: kotlin.Boolean? = null
        /**
         * The validation information during API import. This may include particular properties of your OpenAPI definition which are ignored during import. Supported only for HTTP APIs.
         */
        public var importInfo: List<String>? = null
        /**
         * The name of the API.
         */
        public var name: kotlin.String? = null
        /**
         * The API protocol.
         */
        public var protocolType: aws.sdk.kotlin.services.apigatewayv2.model.ProtocolType? = null
        /**
         * The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.
         */
        public var routeSelectionExpression: kotlin.String? = null
        /**
         * A collection of tags associated with the API.
         */
        public var tags: Map<String, String>? = null
        /**
         * A version identifier for the API.
         */
        public var version: kotlin.String? = null
        /**
         * The warning messages reported when failonwarnings is turned on during API import.
         */
        public var warnings: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigatewayv2.model.CreateApiResponse) : this() {
            this.apiEndpoint = x.apiEndpoint
            this.apiGatewayManaged = x.apiGatewayManaged
            this.apiId = x.apiId
            this.apiKeySelectionExpression = x.apiKeySelectionExpression
            this.corsConfiguration = x.corsConfiguration
            this.createdDate = x.createdDate
            this.description = x.description
            this.disableExecuteApiEndpoint = x.disableExecuteApiEndpoint
            this.disableSchemaValidation = x.disableSchemaValidation
            this.importInfo = x.importInfo
            this.name = x.name
            this.protocolType = x.protocolType
            this.routeSelectionExpression = x.routeSelectionExpression
            this.tags = x.tags
            this.version = x.version
            this.warnings = x.warnings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigatewayv2.model.CreateApiResponse = CreateApiResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.apigatewayv2.model.Cors] inside the given [block]
         */
        public fun corsConfiguration(block: aws.sdk.kotlin.services.apigatewayv2.model.Cors.Builder.() -> kotlin.Unit) {
            this.corsConfiguration = aws.sdk.kotlin.services.apigatewayv2.model.Cors.invoke(block)
        }
    }
}
