// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.model



/**
 * Creates a new RouteResponse resource to represent a route response.
 */
public class CreateRouteResponseRequest private constructor(builder: Builder) {
    /**
     * The API identifier.
     */
    public val apiId: kotlin.String? = requireNotNull(builder.apiId) { "A non-null value must be provided for apiId" }
    /**
     * The model selection expression for the route response. Supported only for WebSocket APIs.
     */
    public val modelSelectionExpression: kotlin.String? = builder.modelSelectionExpression
    /**
     * The response models for the route response.
     */
    public val responseModels: Map<String, String>? = builder.responseModels
    /**
     * The route response parameters.
     */
    public val responseParameters: Map<String, ParameterConstraints>? = builder.responseParameters
    /**
     * The route ID.
     */
    public val routeId: kotlin.String? = requireNotNull(builder.routeId) { "A non-null value must be provided for routeId" }
    /**
     * The route response key.
     */
    public val routeResponseKey: kotlin.String? = builder.routeResponseKey

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigatewayv2.model.CreateRouteResponseRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateRouteResponseRequest(")
        append("apiId=$apiId,")
        append("modelSelectionExpression=$modelSelectionExpression,")
        append("responseModels=$responseModels,")
        append("responseParameters=$responseParameters,")
        append("routeId=$routeId,")
        append("routeResponseKey=$routeResponseKey)")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiId?.hashCode() ?: 0
        result = 31 * result + (modelSelectionExpression?.hashCode() ?: 0)
        result = 31 * result + (responseModels?.hashCode() ?: 0)
        result = 31 * result + (responseParameters?.hashCode() ?: 0)
        result = 31 * result + (routeId?.hashCode() ?: 0)
        result = 31 * result + (routeResponseKey?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateRouteResponseRequest

        if (apiId != other.apiId) return false
        if (modelSelectionExpression != other.modelSelectionExpression) return false
        if (responseModels != other.responseModels) return false
        if (responseParameters != other.responseParameters) return false
        if (routeId != other.routeId) return false
        if (routeResponseKey != other.routeResponseKey) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigatewayv2.model.CreateRouteResponseRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The API identifier.
         */
        public var apiId: kotlin.String? = null
        /**
         * The model selection expression for the route response. Supported only for WebSocket APIs.
         */
        public var modelSelectionExpression: kotlin.String? = null
        /**
         * The response models for the route response.
         */
        public var responseModels: Map<String, String>? = null
        /**
         * The route response parameters.
         */
        public var responseParameters: Map<String, ParameterConstraints>? = null
        /**
         * The route ID.
         */
        public var routeId: kotlin.String? = null
        /**
         * The route response key.
         */
        public var routeResponseKey: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigatewayv2.model.CreateRouteResponseRequest) : this() {
            this.apiId = x.apiId
            this.modelSelectionExpression = x.modelSelectionExpression
            this.responseModels = x.responseModels
            this.responseParameters = x.responseParameters
            this.routeId = x.routeId
            this.routeResponseKey = x.routeResponseKey
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigatewayv2.model.CreateRouteResponseRequest = CreateRouteResponseRequest(this)
    }
}
