// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.model



/**
 * Updates a Stage.
 */
class UpdateStageRequest private constructor(builder: Builder) {
    /**
     * Settings for logging access in this stage.
     */
    val accessLogSettings: aws.sdk.kotlin.services.apigatewayv2.model.AccessLogSettings? = builder.accessLogSettings
    /**
     * The API identifier.
     */
    val apiId: kotlin.String? = requireNotNull(builder.apiId) { "A non-null value must be provided for apiId" }
    /**
     * Specifies whether updates to an API automatically trigger a new deployment. The default value is false.
     */
    val autoDeploy: kotlin.Boolean? = builder.autoDeploy
    /**
     * The identifier of a client certificate for a Stage.
     */
    val clientCertificateId: kotlin.String? = builder.clientCertificateId
    /**
     * The default route settings for the stage.
     */
    val defaultRouteSettings: aws.sdk.kotlin.services.apigatewayv2.model.RouteSettings? = builder.defaultRouteSettings
    /**
     * The deployment identifier for the API stage. Can't be updated if autoDeploy is enabled.
     */
    val deploymentId: kotlin.String? = builder.deploymentId
    /**
     * The description for the API stage.
     */
    val description: kotlin.String? = builder.description
    /**
     * Route settings for the stage.
     */
    val routeSettings: Map<String, RouteSettings>? = builder.routeSettings
    /**
     * The stage name. Stage names can contain only alphanumeric characters, hyphens, and underscores, or be $default. Maximum length is 128 characters.
     */
    val stageName: kotlin.String? = requireNotNull(builder.stageName) { "A non-null value must be provided for stageName" }
    /**
     * A map that defines the stage variables for a Stage. Variable names can have alphanumeric and underscore characters, and the values must match &#91;A-Za-z0-9-._~:/?#&=,&#93;+.
     */
    val stageVariables: Map<String, String>? = builder.stageVariables

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigatewayv2.model.UpdateStageRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateStageRequest(")
        append("accessLogSettings=$accessLogSettings,")
        append("apiId=$apiId,")
        append("autoDeploy=$autoDeploy,")
        append("clientCertificateId=$clientCertificateId,")
        append("defaultRouteSettings=$defaultRouteSettings,")
        append("deploymentId=$deploymentId,")
        append("description=$description,")
        append("routeSettings=$routeSettings,")
        append("stageName=$stageName,")
        append("stageVariables=$stageVariables)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessLogSettings?.hashCode() ?: 0
        result = 31 * result + (apiId?.hashCode() ?: 0)
        result = 31 * result + (autoDeploy?.hashCode() ?: 0)
        result = 31 * result + (clientCertificateId?.hashCode() ?: 0)
        result = 31 * result + (defaultRouteSettings?.hashCode() ?: 0)
        result = 31 * result + (deploymentId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (routeSettings?.hashCode() ?: 0)
        result = 31 * result + (stageName?.hashCode() ?: 0)
        result = 31 * result + (stageVariables?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateStageRequest

        if (accessLogSettings != other.accessLogSettings) return false
        if (apiId != other.apiId) return false
        if (autoDeploy != other.autoDeploy) return false
        if (clientCertificateId != other.clientCertificateId) return false
        if (defaultRouteSettings != other.defaultRouteSettings) return false
        if (deploymentId != other.deploymentId) return false
        if (description != other.description) return false
        if (routeSettings != other.routeSettings) return false
        if (stageName != other.stageName) return false
        if (stageVariables != other.stageVariables) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigatewayv2.model.UpdateStageRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Settings for logging access in this stage.
         */
        var accessLogSettings: aws.sdk.kotlin.services.apigatewayv2.model.AccessLogSettings? = null
        /**
         * The API identifier.
         */
        var apiId: kotlin.String? = null
        /**
         * Specifies whether updates to an API automatically trigger a new deployment. The default value is false.
         */
        var autoDeploy: kotlin.Boolean? = null
        /**
         * The identifier of a client certificate for a Stage.
         */
        var clientCertificateId: kotlin.String? = null
        /**
         * The default route settings for the stage.
         */
        var defaultRouteSettings: aws.sdk.kotlin.services.apigatewayv2.model.RouteSettings? = null
        /**
         * The deployment identifier for the API stage. Can't be updated if autoDeploy is enabled.
         */
        var deploymentId: kotlin.String? = null
        /**
         * The description for the API stage.
         */
        var description: kotlin.String? = null
        /**
         * Route settings for the stage.
         */
        var routeSettings: Map<String, RouteSettings>? = null
        /**
         * The stage name. Stage names can contain only alphanumeric characters, hyphens, and underscores, or be $default. Maximum length is 128 characters.
         */
        var stageName: kotlin.String? = null
        /**
         * A map that defines the stage variables for a Stage. Variable names can have alphanumeric and underscore characters, and the values must match &#91;A-Za-z0-9-._~:/?#&=,&#93;+.
         */
        var stageVariables: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigatewayv2.model.UpdateStageRequest) : this() {
            this.accessLogSettings = x.accessLogSettings
            this.apiId = x.apiId
            this.autoDeploy = x.autoDeploy
            this.clientCertificateId = x.clientCertificateId
            this.defaultRouteSettings = x.defaultRouteSettings
            this.deploymentId = x.deploymentId
            this.description = x.description
            this.routeSettings = x.routeSettings
            this.stageName = x.stageName
            this.stageVariables = x.stageVariables
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigatewayv2.model.UpdateStageRequest = UpdateStageRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.apigatewayv2.model.AccessLogSettings] inside the given [block]
         */
        fun accessLogSettings(block: aws.sdk.kotlin.services.apigatewayv2.model.AccessLogSettings.Builder.() -> kotlin.Unit) {
            this.accessLogSettings = aws.sdk.kotlin.services.apigatewayv2.model.AccessLogSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.apigatewayv2.model.RouteSettings] inside the given [block]
         */
        fun defaultRouteSettings(block: aws.sdk.kotlin.services.apigatewayv2.model.RouteSettings.Builder.() -> kotlin.Unit) {
            this.defaultRouteSettings = aws.sdk.kotlin.services.apigatewayv2.model.RouteSettings.invoke(block)
        }
    }
}
