// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationcostprofiler

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.applicationcostprofiler.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.applicationcostprofiler.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * This reference provides descriptions of the AWS Application Cost Profiler API.
 *
 * The AWS Application Cost Profiler API provides programmatic access to view, create, update, and delete application cost report definitions, as well as to import your usage data into the Application Cost Profiler service.
 *
 * For more information about using this service, see the [AWS Application Cost Profiler User Guide](https://docs.aws.amazon.com/application-cost-profiler/latest/userguide/introduction.html).
 */
interface ApplicationCostProfilerClient : SdkClient {

    override val serviceName: String
        get() = "ApplicationCostProfiler"
    /**
     * ApplicationCostProfilerClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): ApplicationCostProfilerClient {
            val config = Config.Builder().apply(block).build()
            return DefaultApplicationCostProfilerClient(config)
        }

        operator fun invoke(config: Config): ApplicationCostProfilerClient = DefaultApplicationCostProfilerClient(config)

        /**
         * Construct a [ApplicationCostProfilerClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): ApplicationCostProfilerClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultApplicationCostProfilerClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Deletes the specified report definition in AWS Application Cost Profiler. This stops the report from being generated.
     */
    suspend fun deleteReportDefinition(input: DeleteReportDefinitionRequest): DeleteReportDefinitionResponse

    /**
     * Deletes the specified report definition in AWS Application Cost Profiler. This stops the report from being generated.
     */
    suspend fun deleteReportDefinition(block: DeleteReportDefinitionRequest.Builder.() -> Unit) = deleteReportDefinition(DeleteReportDefinitionRequest.Builder().apply(block).build())

    /**
     * Retrieves the definition of a report already configured in AWS Application Cost Profiler.
     */
    suspend fun getReportDefinition(input: GetReportDefinitionRequest): GetReportDefinitionResponse

    /**
     * Retrieves the definition of a report already configured in AWS Application Cost Profiler.
     */
    suspend fun getReportDefinition(block: GetReportDefinitionRequest.Builder.() -> Unit) = getReportDefinition(GetReportDefinitionRequest.Builder().apply(block).build())

    /**
     * Ingests application usage data from Amazon Simple Storage Service (Amazon S3).
     *
     * The data must already exist in the S3 location. As part of the action, AWS Application Cost Profiler copies the object from your S3 bucket to an S3 bucket owned by Amazon for processing asynchronously.
     */
    suspend fun importApplicationUsage(input: ImportApplicationUsageRequest): ImportApplicationUsageResponse

    /**
     * Ingests application usage data from Amazon Simple Storage Service (Amazon S3).
     *
     * The data must already exist in the S3 location. As part of the action, AWS Application Cost Profiler copies the object from your S3 bucket to an S3 bucket owned by Amazon for processing asynchronously.
     */
    suspend fun importApplicationUsage(block: ImportApplicationUsageRequest.Builder.() -> Unit) = importApplicationUsage(ImportApplicationUsageRequest.Builder().apply(block).build())

    /**
     * Retrieves a list of all reports and their configurations for your AWS account.
     *
     * The maximum number of reports is one.
     */
    suspend fun listReportDefinitions(input: ListReportDefinitionsRequest = ListReportDefinitionsRequest {}): ListReportDefinitionsResponse

    /**
     * Retrieves a list of all reports and their configurations for your AWS account.
     *
     * The maximum number of reports is one.
     */
    suspend fun listReportDefinitions(block: ListReportDefinitionsRequest.Builder.() -> Unit) = listReportDefinitions(ListReportDefinitionsRequest.Builder().apply(block).build())

    /**
     * Creates the report definition for a report in Application Cost Profiler.
     */
    suspend fun putReportDefinition(input: PutReportDefinitionRequest): PutReportDefinitionResponse

    /**
     * Creates the report definition for a report in Application Cost Profiler.
     */
    suspend fun putReportDefinition(block: PutReportDefinitionRequest.Builder.() -> Unit) = putReportDefinition(PutReportDefinitionRequest.Builder().apply(block).build())

    /**
     * Updates existing report in AWS Application Cost Profiler.
     */
    suspend fun updateReportDefinition(input: UpdateReportDefinitionRequest): UpdateReportDefinitionResponse

    /**
     * Updates existing report in AWS Application Cost Profiler.
     */
    suspend fun updateReportDefinition(block: UpdateReportDefinitionRequest.Builder.() -> Unit) = updateReportDefinition(UpdateReportDefinitionRequest.Builder().apply(block).build())
}
