// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.applicationcostprofiler

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.services.applicationcostprofiler.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.applicationcostprofiler.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.delay.StandardRetryTokenBucketOptions

/**
 * This reference provides descriptions of the AWS Application Cost Profiler API.
 * The AWS Application Cost Profiler API provides programmatic access to view, create, update, and delete
 * application cost report definitions, as well as to import your usage data into the Application Cost Profiler
 * service.
 * For more information about using this service, see the <a href="https://docs.aws.amazon.com/application-cost-profiler/latest/userguide/introduction.html">AWS Application Cost
 * Profiler User Guide.
 */
interface ApplicationCostProfilerClient : SdkClient {

    override val serviceName: String
        get() = "ApplicationCostProfiler"
    /**
     * ApplicationCostProfilerClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.Builder.() -> Unit = {}): ApplicationCostProfilerClient {
            val config = Config.Builder().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
                sdkLogMode = sharedConfig?.sdkLogMode ?: SdkLogMode.Default
            }.apply(block).build()
            return DefaultApplicationCostProfilerClient(config)
        }

        operator fun invoke(config: Config): ApplicationCostProfilerClient = DefaultApplicationCostProfilerClient(config)

        /**
         * Construct a [ApplicationCostProfilerClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): ApplicationCostProfilerClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return ApplicationCostProfilerClient(sharedConfig)
        }
    }

    class Config private constructor(builder: Builder): AwsClientConfig, HttpClientConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Deletes the specified report definition in AWS Application Cost Profiler. This stops the report from being
     * generated.
     */
    suspend fun deleteReportDefinition(input: DeleteReportDefinitionRequest): DeleteReportDefinitionResponse

    /**
     * Deletes the specified report definition in AWS Application Cost Profiler. This stops the report from being
     * generated.
     */
    suspend fun deleteReportDefinition(block: DeleteReportDefinitionRequest.Builder.() -> Unit) = deleteReportDefinition(DeleteReportDefinitionRequest.Builder().apply(block).build())

    /**
     * Retrieves the definition of a report already configured in AWS Application Cost Profiler.
     */
    suspend fun getReportDefinition(input: GetReportDefinitionRequest): GetReportDefinitionResponse

    /**
     * Retrieves the definition of a report already configured in AWS Application Cost Profiler.
     */
    suspend fun getReportDefinition(block: GetReportDefinitionRequest.Builder.() -> Unit) = getReportDefinition(GetReportDefinitionRequest.Builder().apply(block).build())

    /**
     * Ingests application usage data from Amazon Simple Storage Service (Amazon S3).
     * The data must already exist in the S3 location. As part of the action, AWS Application Cost Profiler
     * copies the object from your S3 bucket to an S3 bucket owned by Amazon for processing
     * asynchronously.
     */
    suspend fun importApplicationUsage(input: ImportApplicationUsageRequest): ImportApplicationUsageResponse

    /**
     * Ingests application usage data from Amazon Simple Storage Service (Amazon S3).
     * The data must already exist in the S3 location. As part of the action, AWS Application Cost Profiler
     * copies the object from your S3 bucket to an S3 bucket owned by Amazon for processing
     * asynchronously.
     */
    suspend fun importApplicationUsage(block: ImportApplicationUsageRequest.Builder.() -> Unit) = importApplicationUsage(ImportApplicationUsageRequest.Builder().apply(block).build())

    /**
     * Retrieves a list of all reports and their configurations for your AWS account.
     * The maximum number of reports is one.
     */
    suspend fun listReportDefinitions(input: ListReportDefinitionsRequest): ListReportDefinitionsResponse

    /**
     * Retrieves a list of all reports and their configurations for your AWS account.
     * The maximum number of reports is one.
     */
    suspend fun listReportDefinitions(block: ListReportDefinitionsRequest.Builder.() -> Unit) = listReportDefinitions(ListReportDefinitionsRequest.Builder().apply(block).build())

    /**
     * Creates the report definition for a report in Application Cost Profiler.
     */
    suspend fun putReportDefinition(input: PutReportDefinitionRequest): PutReportDefinitionResponse

    /**
     * Creates the report definition for a report in Application Cost Profiler.
     */
    suspend fun putReportDefinition(block: PutReportDefinitionRequest.Builder.() -> Unit) = putReportDefinition(PutReportDefinitionRequest.Builder().apply(block).build())

    /**
     * Updates existing report in AWS Application Cost Profiler.
     */
    suspend fun updateReportDefinition(input: UpdateReportDefinitionRequest): UpdateReportDefinitionResponse

    /**
     * Updates existing report in AWS Application Cost Profiler.
     */
    suspend fun updateReportDefinition(block: UpdateReportDefinitionRequest.Builder.() -> Unit) = updateReportDefinition(UpdateReportDefinitionRequest.Builder().apply(block).build())
}
